/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import java.lang.reflect.Type;

public interface OmitValue {
    public boolean shouldOmit(Object var1);

    public String code();

    public static class Parsed
    implements OmitValue {
        private final Object defaultValue;
        private final String code;

        public Parsed(Object defaultValue, String code) {
            this.defaultValue = defaultValue;
            this.code = code;
        }

        public static OmitValue parse(Type valueType, String defaultValueToOmit) {
            if ("void".equals(defaultValueToOmit)) {
                return null;
            }
            if ("null".equals(defaultValueToOmit)) {
                return new Null();
            }
            if (Boolean.TYPE.equals(valueType)) {
                Boolean defaultValue = Boolean.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s");
            }
            if (Boolean.class.equals((Object)valueType)) {
                Boolean defaultValue = Boolean.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s.booleanValue()");
            }
            if (Integer.TYPE.equals(valueType)) {
                Integer defaultValue = Integer.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s");
            }
            if (Integer.class.equals((Object)valueType)) {
                Integer defaultValue = Integer.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s.intValue()");
            }
            if (Byte.TYPE.equals(valueType)) {
                Byte defaultValue = Byte.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s");
            }
            if (Byte.class.equals((Object)valueType)) {
                Byte defaultValue = Byte.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s.byteValue()");
            }
            if (Short.TYPE.equals(valueType)) {
                Short defaultValue = Short.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s");
            }
            if (Short.class.equals((Object)valueType)) {
                Short defaultValue = Short.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + " == %s.shortValue()");
            }
            if (Long.TYPE.equals(valueType)) {
                Long defaultValue = Long.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + "L == %s");
            }
            if (Long.class.equals((Object)valueType)) {
                Long defaultValue = Long.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + "L == %s.longValue()");
            }
            if (Float.TYPE.equals(valueType)) {
                Float defaultValue = Float.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + "F == %s");
            }
            if (Float.class.equals((Object)valueType)) {
                Float defaultValue = Float.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + "F == %s.floatValue()");
            }
            if (Double.TYPE.equals(valueType)) {
                Double defaultValue = Double.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + "D == %s");
            }
            if (Double.class.equals((Object)valueType)) {
                Double defaultValue = Double.valueOf(defaultValueToOmit);
                return new Parsed(defaultValue, defaultValueToOmit + "D == %s.doubleValue()");
            }
            if (Character.TYPE.equals(valueType) && defaultValueToOmit.length() == 1) {
                Character defaultValue = Character.valueOf(defaultValueToOmit.charAt(0));
                return new Parsed(defaultValue, "'" + defaultValueToOmit + "' == %s");
            }
            if (Character.class.equals((Object)valueType) && defaultValueToOmit.length() == 1) {
                Character defaultValue = Character.valueOf(defaultValueToOmit.charAt(0));
                return new Parsed(defaultValue, "'" + defaultValueToOmit + "' == %s.charValue()");
            }
            throw new UnsupportedOperationException("failed to parse defaultValueToOmit: " + defaultValueToOmit);
        }

        @Override
        public boolean shouldOmit(Object val2) {
            return this.defaultValue.equals(val2);
        }

        @Override
        public String code() {
            return this.code;
        }
    }

    public static class False
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return (Boolean)val2 == false;
        }

        @Override
        public String code() {
            return "false == %s";
        }
    }

    public static class ZeroChar
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return ((Character)val2).charValue() == '\u0000';
        }

        @Override
        public String code() {
            return "0 == %s";
        }
    }

    public static class ZeroDouble
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return (Double)val2 == 0.0;
        }

        @Override
        public String code() {
            return "0 == %s";
        }
    }

    public static class ZeroFloat
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return ((Float)val2).floatValue() == 0.0f;
        }

        @Override
        public String code() {
            return "0 == %s";
        }
    }

    public static class ZeroLong
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return (Long)val2 == 0L;
        }

        @Override
        public String code() {
            return "0 == %s";
        }
    }

    public static class ZeroInt
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return (Integer)val2 == 0;
        }

        @Override
        public String code() {
            return "0 == %s";
        }
    }

    public static class ZeroShort
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return (Short)val2 == 0;
        }

        @Override
        public String code() {
            return "0 == %s";
        }
    }

    public static class ZeroByte
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return (Byte)val2 == 0;
        }

        @Override
        public String code() {
            return "0 == %s";
        }
    }

    public static class Null
    implements OmitValue {
        @Override
        public boolean shouldOmit(Object val2) {
            return val2 == null;
        }

        @Override
        public String code() {
            return "null == %s";
        }
    }
}

