/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.language.searchcriteria;

import com.imperva.ddc.core.exceptions.ParsingException;
import com.imperva.ddc.core.language.Phrase;
import com.imperva.ddc.core.language.Sentence;
import com.imperva.ddc.core.language.Word;
import com.imperva.ddc.core.language.searchcriteria.SearchCriteria;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.RequestBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchCriteriaBuilder
extends RequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchCriteriaBuilder.class.getName());
    private QueryRequest queryRequest;

    protected String translateFilter(Word word) {
        if (word == null) {
            throw new ParsingException("Phrases and Sentences can't be empty");
        }
        String result = "";
        if (word instanceof Phrase) {
            Phrase phrase = (Phrase)word;
            String escapedValue = SearchCriteriaBuilder.escapeSpecialChars(phrase.getValue(), phrase.getAttribute());
            phrase.setValue(escapedValue);
            result = result + this.translatePhrase(phrase);
        } else if (word instanceof Sentence) {
            Sentence sentence = (Sentence)word;
            String translatedFilter = this.translateFilter(sentence.getSentences());
            result = result + SearchCriteriaBuilder.translateSentence(translatedFilter, sentence);
        }
        return result.trim();
    }

    protected String translateFilter(List<Word> words) {
        String result = "";
        for (Word word : words) {
            result = result + this.translateFilter(word);
        }
        return result.trim();
    }

    protected static String translateSentence(String translatedPhrase, Sentence sentence) {
        String result = "";
        String translatedSentence = "(%s%s)";
        switch (sentence.getOperator()) {
            case AND: {
                translatedSentence = String.format(translatedSentence, "&", translatedPhrase);
                break;
            }
            case OR: {
                translatedSentence = String.format(translatedSentence, "|", translatedPhrase);
                break;
            }
            case EMPTY: {
                translatedSentence = translatedPhrase;
                break;
            }
            default: {
                translatedSentence = "";
            }
        }
        result = result + translatedSentence;
        return result.trim();
    }

    protected String translatePhrase(Phrase phrase) {
        String result = "";
        String translatedPhraseTemplate = "(%s%s%s)";
        String translatedPhraseTemplate2 = "(%s%s%s%s%s)";
        String translatedPhraseTemplate3 = "(%s%s%s%s%s)";
        String attr = this.translateField(phrase.getAttribute());
        String value = phrase.getValue();
        switch (phrase.getPhraseOperator()) {
            case EQUAL: {
                result = result + String.format(translatedPhraseTemplate, attr, "=", value);
                break;
            }
            case GREATERTHAN: {
                result = result + String.format(translatedPhraseTemplate, attr, ">", value);
                break;
            }
            case GREATERTHANOREQUAL: {
                result = result + String.format(translatedPhraseTemplate, attr, ">=", value);
                break;
            }
            case NOTEQUAL: {
                result = result + String.format(translatedPhraseTemplate2, "!(", attr, "=", value, ")");
                break;
            }
            case SMALLERTHAN: {
                result = result + String.format(translatedPhraseTemplate, attr, "<", value);
                break;
            }
            case SMALLERTHANOREQUAL: {
                result = result + String.format(translatedPhraseTemplate, attr, "<=", value);
                break;
            }
            case CONTAINS: {
                result = result + String.format(translatedPhraseTemplate3, attr, "=", "*", value, "*");
                break;
            }
            default: {
                result = result + "";
            }
        }
        return result.trim();
    }

    protected QueryRequest getQueryRequest() {
        return this.queryRequest;
    }

    public void setQueryRequest(QueryRequest queryRequest) {
        this.queryRequest = queryRequest;
    }

    public abstract void translateFields();

    public abstract SearchCriteria get();
}

