/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.ApacheAPIConverter;
import com.imperva.ddc.core.QueryRequestExecutor;
import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.exceptions.BaseException;
import com.imperva.ddc.core.exceptions.QueryFailedException;
import com.imperva.ddc.core.query.CursorStatus;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.LdapConnectionResult;
import com.imperva.ddc.core.query.Oops;
import com.imperva.ddc.core.query.PartitionResponse;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.QueryResponse;
import com.imperva.ddc.core.query.RoundtripResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryRequestPagedExecutor
extends QueryRequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRequestPagedExecutor.class.getName());

    QueryRequestPagedExecutor(QueryRequest queryRequest) {
        super(queryRequest);
    }

    @Override
    QueryResponse execute() {
        QueryResponse response = new QueryResponse();
        for (Endpoint endpoint : this.queryRequest.getEndpoints()) {
            PartitionResponse partitionResponse = new PartitionResponse();
            response.addPartitionResponse(partitionResponse);
            partitionResponse.setEndpoint(endpoint);
            try {
                LOGGER.debug("Executing request for: " + endpoint.getHost());
                if (endpoint.hasNext() == CursorStatus.EOF) {
                    LOGGER.debug("Host " + endpoint.getHost() + " skipped: EOF");
                    continue;
                }
                LdapConnectionResult ldapConnectionResult = this.driverGetInstance().connect(endpoint);
                String basePath = this.tryResolveBasePath(ldapConnectionResult.getConnection(), endpoint.getBaseSearchPath());
                endpoint.setBaseSearchPath(basePath);
                endpoint.setDestinationType(ldapConnectionResult.getDestinationType());
                partitionResponse.setStatus(ldapConnectionResult.getStatuses());
                LdapConnection connection = ldapConnectionResult.getConnection();
                if (ldapConnectionResult.connectionSucceeded()) {
                    SearchRequest search = this.parserGetInstance().toSearchRequest(this.queryRequest, endpoint.getBaseSearchPath(), endpoint.getCookie());
                    RoundtripResult roundtripResult = this.collectData(connection, search);
                    Object cookie = this.retrieveCookie(roundtripResult.getSearchCursor());
                    endpoint.setCookie(cookie);
                    if (cookie == null) {
                        endpoint.hasNext(CursorStatus.EOF);
                    } else {
                        endpoint.hasNext(CursorStatus.PAGING);
                    }
                    partitionResponse.setData(new ApacheAPIConverter().toEntityResponse(roundtripResult.getData(), this.queryRequest.getRequestedFields()));
                    return response;
                }
                LOGGER.error(String.format("Could not execute query against AD {}. Connection failure!", endpoint.getHost()));
                endpoint.hasNext(CursorStatus.EOF);
                endpoint.setDestinationType(DestinationType.NONE);
            }
            catch (BaseException | LdapException e) {
                LOGGER.error("Query Execution failed for Endpoint:" + endpoint.getHost(), e);
                partitionResponse.addStatus(endpoint.getHost(), new Oops(e));
                if (!Utils.isEmpty(endpoint.getSecondaryHost())) {
                    partitionResponse.addStatus(endpoint.getSecondaryHost(), new Oops(e));
                }
                endpoint.hasNext(CursorStatus.EOF);
                endpoint.setDestinationType(DestinationType.NONE);
            }
            catch (Exception e) {
                endpoint.hasNext(CursorStatus.EOF);
                endpoint.setDestinationType(DestinationType.NONE);
                LOGGER.error("Some unhandled exception occurred at Endpoint: " + endpoint.getHost(), e);
                throw e;
            }
        }
        return response;
    }

    Object retrieveCookie(SearchCursor cursor) {
        SearchResultDone result = cursor.getSearchResultDone();
        PagedResults pagedSearchControl = (PagedResults)result.getControl("1.2.840.113556.1.4.319");
        LOGGER.trace("Retrieving cookie. Page control: {}", (Object)pagedSearchControl);
        ResultCodeEnum resultCodeEnum = result.getLdapResult().getResultCode();
        LOGGER.trace("Retrieving cookie. Result Code: {}", (Object)resultCodeEnum.getMessage());
        if (resultCodeEnum == ResultCodeEnum.UNWILLING_TO_PERFORM || resultCodeEnum == ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION || pagedSearchControl == null) {
            throw new QueryFailedException("AD can't handle paging. pagedSearchControl null?: " + (pagedSearchControl == null) + ", result.getLdapResult().getResultCode(): " + result.getLdapResult().getResultCode().name());
        }
        byte[] cookie = pagedSearchControl.getCookie();
        LOGGER.trace("Retrieving cookie. Cookie value: {}", (Object)cookie);
        return cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RoundtripResult collectData(LdapConnection connection, SearchRequest searchRequest) {
        RoundtripResult roundtripResult = new RoundtripResult();
        List<Object> results = new ArrayList();
        SearchCursor cursor = null;
        try {
            cursor = connection.search(searchRequest);
            results = this.run(cursor);
        }
        catch (LdapException e) {
            LOGGER.error("Search failed", e.getStackTrace());
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (IOException e) {
                    LOGGER.error("Can't close cursor", e.getStackTrace());
                }
            }
        }
        LOGGER.trace("Retrieving cookie. Data size: {}", results == null ? "NaN" : Integer.valueOf(results.size()));
        roundtripResult.setData(results);
        roundtripResult.setSearchCursor(cursor);
        return roundtripResult;
    }
}

