/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.future;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.ldap.client.api.LdapConnection;

public class ResponseFuture<R extends Response>
implements Future<Response> {
    protected BlockingQueue<R> queue = new LinkedBlockingQueue<R>();
    protected boolean cancelled = false;
    protected Throwable cause;
    protected int messageId;
    protected LdapConnection connection;

    public ResponseFuture(LdapConnection connection, int messageId) {
        this.messageId = messageId;
        this.connection = connection;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled) {
            return this.cancelled;
        }
        this.cancelled = true;
        if (!this.connection.isRequestCompleted(this.messageId)) {
            this.connection.abandon(this.messageId);
        }
        this.queue.clear();
        return this.cancelled;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        Response response = null;
        response = (Response)this.queue.take();
        return (R)response;
    }

    public void set(R response) throws InterruptedException, ExecutionException {
        this.queue.add(response);
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Response response = (Response)this.queue.poll(timeout, unit);
        return (R)response;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[msgId : ").append(this.messageId).append(", ");
        sb.append("size : ").append(this.queue.size()).append(", ");
        sb.append("Canceled :").append(this.cancelled).append("]");
        return sb.toString();
    }
}

