/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.AbstractValue;
import org.apache.directory.api.ldap.model.entry.BinaryValue;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.ComplexDnParser;
import org.apache.directory.api.ldap.model.name.FastDnParser;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.name.TooComplexDnException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dn
implements Iterable<Rdn>,
Externalizable {
    protected static final Logger LOG = LoggerFactory.getLogger(Dn.class);
    private static final long serialVersionUID = 1L;
    public static final int NOT_EQUAL = -1;
    public static final int EQUAL = 0;
    protected List<Rdn> rdns;
    private String upName;
    private String normName;
    private byte[] bytes;
    public static final Dn EMPTY_DN = new Dn();
    public static final Dn ROOT_DSE = new Dn();
    private SchemaManager schemaManager;

    public Dn() {
        this((SchemaManager)null);
    }

    public Dn(SchemaManager schemaManager) {
        this.rdns = new ArrayList<Rdn>(5);
        this.schemaManager = schemaManager;
        this.upName = "";
        this.normName = "";
    }

    public Dn(String ... upRdns) throws LdapInvalidDnException {
        this((SchemaManager)null, upRdns);
    }

    public Dn(SchemaManager schemaManager, String ... upRdns) throws LdapInvalidDnException {
        block8: {
            this.rdns = new ArrayList<Rdn>(5);
            StringBuilder sb = new StringBuilder();
            boolean valueExpected = false;
            boolean isFirst = true;
            for (String upRdn : upRdns) {
                if (Strings.isEmpty(upRdn)) continue;
                if (isFirst) {
                    isFirst = false;
                } else if (!valueExpected) {
                    sb.append(',');
                }
                if (!valueExpected) {
                    sb.append(upRdn);
                    if (upRdn.indexOf(61) != -1) continue;
                    valueExpected = true;
                    continue;
                }
                sb.append("=").append(upRdn);
                valueExpected = false;
            }
            if (!isFirst && valueExpected) {
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err(I18n.ERR_04202, new Object[0]));
            }
            this.upName = sb.toString();
            try {
                Dn.parseInternal(this.upName, this.rdns);
                this.apply(schemaManager);
            }
            catch (LdapInvalidDnException e) {
                if (schemaManager != null && schemaManager.isRelaxed()) break block8;
                throw e;
            }
        }
    }

    Dn(SchemaManager schemaManager, String upName, String normName, Rdn ... rdns) {
        this.rdns = new ArrayList<Rdn>(5);
        this.schemaManager = schemaManager;
        this.upName = upName;
        this.normName = normName;
        this.bytes = Strings.getBytesUtf8Ascii(upName);
        this.rdns = Arrays.asList(rdns);
    }

    public Dn(Rdn ... rdns) throws LdapInvalidDnException {
        this.rdns = new ArrayList<Rdn>(5);
        if (rdns == null) {
            return;
        }
        for (Rdn rdn : rdns) {
            this.rdns.add(rdn);
        }
        this.apply(null);
        this.toUpName();
    }

    public Dn(Rdn rdn, Dn dn) throws LdapInvalidDnException {
        this.rdns = new ArrayList<Rdn>(5);
        if (dn == null || rdn == null) {
            throw new IllegalArgumentException("Either the dn or the rdn is null");
        }
        for (Rdn rdnParent : dn) {
            this.rdns.add(0, rdnParent);
        }
        this.rdns.add(0, rdn);
        this.apply(dn.schemaManager);
        this.toUpName();
    }

    public Dn(SchemaManager schemaManager, Rdn ... rdns) throws LdapInvalidDnException {
        this.rdns = new ArrayList<Rdn>(5);
        if (rdns == null) {
            return;
        }
        for (Rdn rdn : rdns) {
            this.rdns.add(rdn);
        }
        this.apply(schemaManager);
        this.toUpName();
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    private String toUpName() {
        if (this.rdns.size() == 0) {
            this.upName = "";
        } else {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (Rdn rdn : this.rdns) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(rdn.getName());
            }
            this.upName = sb.toString();
        }
        return this.upName;
    }

    public int hashCode() {
        int result = 37;
        for (Rdn rdn : this.rdns) {
            result = result * 17 + rdn.hashCode();
        }
        return result;
    }

    public String getName() {
        return this.upName == null ? "" : this.upName;
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    public String getNormName() {
        return this.normName;
    }

    public int size() {
        return this.rdns.size();
    }

    public static int getNbBytes(Dn dn) {
        return dn.bytes == null ? 0 : dn.bytes.length;
    }

    public static byte[] getBytes(Dn dn) {
        return dn == null ? null : dn.bytes;
    }

    public boolean isAncestorOf(String dn) {
        try {
            return this.isAncestorOf(new Dn(dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isAncestorOf(Dn dn) {
        if (dn == null) {
            return false;
        }
        return dn.isDescendantOf(this);
    }

    public boolean isDescendantOf(String dn) {
        try {
            return this.isDescendantOf(new Dn(this.schemaManager, dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isDescendantOf(Dn dn) {
        if (dn == null || dn.isRootDse()) {
            return true;
        }
        if (dn.size() > this.size()) {
            return false;
        }
        for (int i = dn.size() - 1; i >= 0; --i) {
            Rdn ldapRdn;
            Rdn nameRdn = dn.rdns.get(dn.rdns.size() - i - 1);
            if (nameRdn.equals(ldapRdn = this.rdns.get(this.rdns.size() - i - 1))) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.rdns.size() == 0;
    }

    public boolean isRootDse() {
        return this.rdns.size() == 0;
    }

    public Rdn getRdn(int posn) {
        if (this.rdns.size() == 0) {
            return null;
        }
        if (posn < 0 || posn >= this.rdns.size()) {
            throw new IllegalArgumentException("Invalid position : " + posn);
        }
        Rdn rdn = this.rdns.get(posn);
        return rdn;
    }

    public Rdn getRdn() {
        if (Dn.isNullOrEmpty(this)) {
            return Rdn.EMPTY_RDN;
        }
        return this.rdns.get(0);
    }

    public List<Rdn> getRdns() {
        return UnmodifiableList.decorate(this.rdns);
    }

    public Dn getDescendantOf(String ancestor) throws LdapInvalidDnException {
        return this.getDescendantOf(new Dn(this.schemaManager, ancestor));
    }

    public Dn getDescendantOf(Dn ancestor) throws LdapInvalidDnException {
        int i;
        if (ancestor == null || ancestor.size() == 0) {
            return this;
        }
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        int length = ancestor.size();
        if (length > this.rdns.size()) {
            String message = I18n.err(I18n.ERR_04206, length, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Dn newDn = new Dn(this.schemaManager);
        List<Rdn> rdnsAncestor = ancestor.getRdns();
        for (i = 0; i < ancestor.size(); ++i) {
            Rdn rdnDescendant;
            Rdn rdn = this.rdns.get(this.size() - 1 - i);
            if (rdn.equals(rdnDescendant = rdnsAncestor.get(ancestor.size() - 1 - i))) continue;
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX);
        }
        for (i = 0; i < this.rdns.size() - length; ++i) {
            newDn.rdns.add(this.rdns.get(i));
        }
        newDn.toUpName();
        newDn.apply(this.schemaManager, true);
        return newDn;
    }

    public Dn getAncestorOf(String descendant) throws LdapInvalidDnException {
        return this.getAncestorOf(new Dn(this.schemaManager, descendant));
    }

    public Dn getAncestorOf(Dn descendant) throws LdapInvalidDnException {
        int i;
        if (descendant == null || descendant.size() == 0) {
            return this;
        }
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        int length = descendant.size();
        if (length > this.rdns.size()) {
            String message = I18n.err(I18n.ERR_04206, length, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Dn newDn = new Dn(this.schemaManager);
        List<Rdn> rdnsDescendant = descendant.getRdns();
        for (i = 0; i < descendant.size(); ++i) {
            Rdn rdnDescendant;
            Rdn rdn = this.rdns.get(i);
            if (rdn.equals(rdnDescendant = rdnsDescendant.get(i))) continue;
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX);
        }
        for (i = length; i < this.rdns.size(); ++i) {
            newDn.rdns.add(this.rdns.get(i));
        }
        newDn.toUpName();
        newDn.apply(this.schemaManager, true);
        return newDn;
    }

    public Dn add(Dn suffix) throws LdapInvalidDnException {
        if (suffix == null || suffix.size() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        clonedDn.rdns.addAll(0, suffix.rdns);
        if (clonedDn.isSchemaAware() && suffix.isSchemaAware()) {
            if (clonedDn.size() != 0) {
                clonedDn.normName = suffix.getNormName() + "," + this.normName;
                clonedDn.bytes = Strings.getBytesUtf8Ascii(this.normName);
                clonedDn.upName = suffix.getName() + "," + this.upName;
            }
        } else {
            clonedDn.apply(this.schemaManager, true);
            clonedDn.toUpName();
        }
        return clonedDn;
    }

    public Dn add(String comp) throws LdapInvalidDnException {
        if (comp.length() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        Rdn newRdn = new Rdn(this.schemaManager, comp);
        clonedDn.rdns.add(0, newRdn);
        clonedDn.apply(this.schemaManager, true);
        clonedDn.toUpName();
        return clonedDn;
    }

    public Dn add(Rdn newRdn) throws LdapInvalidDnException {
        if (newRdn == null || newRdn.size() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        clonedDn.rdns.add(0, newRdn);
        clonedDn.apply(this.schemaManager, true);
        clonedDn.toUpName();
        return clonedDn;
    }

    public Dn getParent() {
        if (Dn.isNullOrEmpty(this)) {
            return this;
        }
        int posn = this.rdns.size() - 1;
        Dn newDn = new Dn(this.schemaManager);
        for (int i = this.rdns.size() - posn; i < this.rdns.size(); ++i) {
            newDn.rdns.add(this.rdns.get(i));
        }
        try {
            newDn.apply(this.schemaManager, true);
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), e);
        }
        newDn.toUpName();
        return newDn;
    }

    private Dn copy() {
        Dn dn = new Dn(this.schemaManager);
        dn.rdns = new ArrayList<Rdn>();
        for (Rdn rdn : this.rdns) {
            dn.rdns.add(rdn);
        }
        return dn;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.normName.equals(obj);
        }
        if (obj instanceof Dn) {
            Dn name = (Dn)obj;
            if (name.getNormName().equals(this.normName)) {
                return true;
            }
            if (name.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (name.rdns.get(i).equals(this.rdns.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Ava atavOidToName(Ava atav, SchemaManager schemaManager) throws LdapInvalidDnException {
        Map<String, OidNormalizer> oidsMap = schemaManager.getNormalizerMapping();
        String type = Strings.trim(atav.getNormType());
        if (type.startsWith("oid.") || type.startsWith("OID.")) {
            type = type.substring(4);
        }
        if (Strings.isNotEmpty(type)) {
            if (oidsMap == null) {
                return atav;
            }
            if (!oidsMap.containsKey(type = Strings.toLowerCaseAscii(type))) {
                String msg = I18n.err(I18n.ERR_04268_OID_NOT_FOUND, atav.getType());
                LOG.error(msg);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, msg);
            }
            OidNormalizer oidNormalizer = oidsMap.get(type);
            if (oidNormalizer != null) {
                try {
                    AttributeType attributeType = schemaManager.getAttributeType(type);
                    if (attributeType == null) {
                        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, type));
                    }
                    AbstractValue atavValue = null;
                    Value<?> value = atav.getValue();
                    atavValue = value instanceof StringValue ? (attributeType.getSyntax() == null || attributeType.getSyntax().isHumanReadable() ? new StringValue(attributeType, value.getString()) : new BinaryValue(attributeType, value.getBytes())) : new BinaryValue(attributeType, atav.getValue().getBytes());
                    Ava newAva = new Ava(attributeType, atav.getType(), oidNormalizer.getAttributeTypeOid(), atavValue, atav.getName());
                    return newAva;
                }
                catch (LdapException le) {
                    throw new LdapInvalidDnException(le.getMessage(), le);
                }
            }
            return atav;
        }
        String msg = I18n.err(I18n.ERR_04209_EMPTY_TYPE_NOT_ALLOWED, new Object[0]);
        LOG.error(msg);
        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, msg);
    }

    static void rdnOidToName(Rdn rdn, SchemaManager schemaManager) throws LdapInvalidDnException {
        if (rdn.size() < 2) {
            Ava newAtav = Dn.atavOidToName(rdn.getAva(), schemaManager);
            rdn.replaceAva(newAtav, 0);
        } else {
            TreeSet<String> sortedOids = new TreeSet<String>();
            HashMap<String, Ava> avas = new HashMap<String, Ava>();
            for (Ava val2 : rdn) {
                Ava newAtav = Dn.atavOidToName(val2, schemaManager);
                String oid = newAtav.getAttributeType().getOid();
                sortedOids.add(oid);
                avas.put(oid, newAtav);
            }
            int pos = 0;
            for (String oid : sortedOids) {
                rdn.replaceAva((Ava)avas.get(oid), pos++);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dn apply(SchemaManager schemaManager, boolean force) throws LdapInvalidDnException {
        if (this.schemaManager == null || force) {
            this.schemaManager = schemaManager;
            if (this.schemaManager != null) {
                Dn dn = this;
                synchronized (dn) {
                    if (this.size() == 0) {
                        this.bytes = null;
                        this.normName = "";
                        return this;
                    }
                    StringBuilder sb = new StringBuilder();
                    boolean isFirst = true;
                    for (Rdn rdn : this.rdns) {
                        rdn.apply(schemaManager);
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(',');
                        }
                        sb.append(rdn.getNormName());
                    }
                    String newNormName = sb.toString();
                    if (this.normName == null || !this.normName.equals(newNormName)) {
                        this.bytes = Strings.getBytesUtf8Ascii(newNormName);
                        this.normName = newNormName;
                    }
                }
            } else if (this.rdns.size() == 0) {
                this.bytes = null;
                this.normName = "";
            } else {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (Rdn rdn : this.rdns) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(rdn.getNormName());
                }
                String newNormName = sb.toString();
                if (this.normName == null || !this.normName.equals(newNormName)) {
                    this.bytes = Strings.getBytesUtf8Ascii(newNormName);
                    this.normName = newNormName;
                }
            }
        }
        return this;
    }

    public Dn apply(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (this.schemaManager != null) {
            return this;
        }
        return this.apply(schemaManager, true);
    }

    public boolean isSchemaAware() {
        return this.schemaManager != null;
    }

    @Override
    public Iterator<Rdn> iterator() {
        return new RdnIterator();
    }

    public static boolean isNullOrEmpty(Dn dn) {
        return dn == null || dn.isEmpty();
    }

    public static boolean isValid(String name) {
        Dn dn = new Dn();
        try {
            Dn.parseInternal(name, dn.rdns);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    private static void parseInternal(String name, List<Rdn> rdns) throws LdapInvalidDnException {
        try {
            FastDnParser.parseDn(name, rdns);
        }
        catch (TooComplexDnException e) {
            rdns.clear();
            new ComplexDnParser().parseDn(name, rdns);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.upName = in.readUTF();
        this.normName = in.readUTF();
        if (this.normName.length() == 0) {
            this.normName = this.upName;
        }
        this.bytes = Strings.getBytesUtf8Ascii(this.normName);
        int nbRdns = in.readInt();
        this.rdns = new ArrayList<Rdn>(nbRdns);
        for (int i = 0; i < nbRdns; ++i) {
            Rdn rdn = new Rdn(this.schemaManager);
            rdn.readExternal(in);
            this.rdns.add(rdn);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.upName == null) {
            String message = "Cannot serialize a NULL Dn";
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(this.upName);
        if (this.upName.equals(this.normName)) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.normName);
        }
        out.writeInt(this.size());
        for (Rdn rdn : this.rdns) {
            rdn.writeExternal(out);
        }
        out.flush();
    }

    public String toString() {
        return this.getName();
    }

    private final class RdnIterator
    implements Iterator<Rdn> {
        int index;

        private RdnIterator() {
            this.index = Dn.this.rdns != null ? Dn.this.rdns.size() - 1 : -1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public Rdn next() {
            return this.index >= 0 ? Dn.this.rdns.get(this.index--) : null;
        }

        @Override
        public void remove() {
        }
    }
}

