/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

public enum SortResultCode {
    SUCCESS(0, "Results are sorted"),
    OPERATIONSERROR(1, "Server internal failure"),
    TIMELIMITEXCEEDED(3, "Timelimit reached before sorting was completed"),
    STRONGAUTHREQUIRED(8, "Refused to return sorted results via insecure protocol"),
    ADMINLIMITEXCEEDED(11, "Too many matching entries for the server to sort"),
    NOSUCHATTRIBUTE(16, "Unrecognized attribute type in sort key"),
    INAPPROPRIATEMATCHING(18, "Unrecognized or inappropriate matching rule in sort key"),
    INSUFFICIENTACCESSRIGHTS(50, "Refused to return sorted results to this client"),
    BUSY(51, "Too busy to process"),
    UNWILLINGTOPERFORM(53, "Unable to sort"),
    OTHER(80, "Other");

    int val;
    String desc;

    private SortResultCode(int val2, String desc) {
        this.val = val2;
        this.desc = desc;
    }

    public int getVal() {
        return this.val;
    }

    public static SortResultCode get(int code) {
        switch (code) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OPERATIONSERROR;
            }
            case 3: {
                return TIMELIMITEXCEEDED;
            }
            case 8: {
                return STRONGAUTHREQUIRED;
            }
            case 11: {
                return ADMINLIMITEXCEEDED;
            }
            case 16: {
                return NOSUCHATTRIBUTE;
            }
            case 18: {
                return INAPPROPRIATEMATCHING;
            }
            case 50: {
                return INSUFFICIENTACCESSRIGHTS;
            }
            case 51: {
                return BUSY;
            }
            case 53: {
                return UNWILLINGTOPERFORM;
            }
            case 80: {
                return OTHER;
            }
        }
        throw new IllegalArgumentException("Unknown sort response result code " + code);
    }
}

