/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.update;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileWriter;
import java.io.IOException;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.responses.SubscriptionStatusResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.licensing.LicenseService;
import org.json.JSONObject;

@WebServlet(value={"/api/admin/subscription"})
public class SubscriptionServlet
extends HttpServlet {
    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        SubscriptionStatusResponse subscriptionStatusResponse = new SubscriptionStatusResponse();
        subscriptionStatusResponse.setLicenseInformation(Server.licenseService.getLicenseInformation());
        subscriptionStatusResponse.setActivated(Boolean.valueOf(Server.activated.get()));
        resp.getOutputStream().write(JsonStream.serialize(subscriptionStatusResponse).getBytes());
        resp.getOutputStream().close();
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String license = new String(req.getInputStream().readAllBytes());
        JSONObject obj = new JSONObject(license);
        if ((license = obj.getString("base64License")) != null || !license.isBlank()) {
            FileWriter fw = new FileWriter("license.dat");
            fw.write(license);
            fw.close();
            LicenseService licenseService = new LicenseService();
            licenseService.loadLicense();
            if (Server.activated.get()) {
                resp.setStatus(200);
                return;
            }
        }
        resp.setStatus(500);
    }
}

