/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Policy;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.json.JSONObject;

@WebServlet(value={"/api/admin/policy"})
public class PolicyServlet
extends HttpServlet {
    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        if (!name.equals("*")) {
            StatementList statementList = new StatementList();
            StatementElement st = new StatementElement("name", "=", name, "");
            statementList.addStatement(st);
            resp.getOutputStream().write(JsonStream.serialize(Server.dataStore.getPolicyDao().getObjects(statementList).get(0)).getBytes());
            resp.setStatus(200);
        } else {
            List policies = Server.dataStore.getPolicyDao().getObjects(null);
            resp.getOutputStream().write(JsonStream.serialize(policies).getBytes());
            resp.setStatus(200);
        }
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        Scanner s = new Scanner(req.getInputStream()).useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        JSONObject obj = new JSONObject(result);
        String jsonString = obj.toString();
        StatementList update = new StatementList();
        StatementElement st0 = new StatementElement("name", "=", name, "");
        update.addStatement(st0);
        StatementElement st2 = new StatementElement("policyData", "=", jsonString, "");
        update.addStatement(st2);
        StatementList constraint = new StatementList();
        StatementElement st3 = new StatementElement("name", "=", name, "");
        constraint.addStatement(st3);
        if (Server.dataStore.getPolicyDao().updateObject(update, constraint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "could not update the group's name!");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        Scanner s = new Scanner(req.getInputStream()).useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        JSONObject obj = new JSONObject(result);
        String jsonString = obj.toString();
        Policy policy = new Policy();
        policy.setName(name);
        policy.setPolicyData(jsonString);
        if (Server.dataStore.getPolicyDao().storeObject(policy)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Could not create a group successfully!");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        StatementElement statementElement = new StatementElement("name", "=", name, "");
        StatementList constraint = new StatementList();
        constraint.addStatement(statementElement);
        if (Server.dataStore.getPolicyDao().deleteObject(constraint)) {
            resp.setStatus(200);
        }
        resp.sendError(500, "Could not delete the blueprint successfully!");
    }
}

