/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core;

import java.io.File;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatConnectorFactory {
    private static final Logger log = LoggerFactory.getLogger(TomcatConnectorFactory.class);

    public static Connector getSSLConnectorWithTrustStore(String certificateFile, String keyFile, int port) {
        log.info(System.getProperty("user.dir") + File.separator + "keystore.jks");
        Connector connector = TomcatConnectorFactory.getSSLConnectorWithoutTrustStore(certificateFile, keyFile, port);
        connector.findSslHostConfigs()[0].setTruststoreFile(System.getProperty("user.dir") + File.separator + "keystore.jks");
        connector.findSslHostConfigs()[0].setTruststorePassword("changeit");
        connector.findSslHostConfigs()[0].setCertificateVerification("optional");
        return connector;
    }

    public static Connector getSSLConnectorWithoutTrustStore(String certificateFile, String keyFile, int port) {
        Connector connector = new Connector();
        SSLHostConfig sslConfig = new SSLHostConfig();
        SSLHostConfigCertificate sslHostConfigCertificate = new SSLHostConfigCertificate(sslConfig, SSLHostConfigCertificate.Type.RSA);
        sslHostConfigCertificate.setCertificateChainFile(System.getProperty("user.dir") + File.separator + certificateFile);
        sslHostConfigCertificate.setCertificateFile(System.getProperty("user.dir") + File.separator + certificateFile);
        sslHostConfigCertificate.setCertificateKeyFile(System.getProperty("user.dir") + File.separator + keyFile);
        sslConfig.addCertificate(sslHostConfigCertificate);
        sslConfig.setProtocols("TLSv1,TLSv1.2,TLSv1.3");
        connector.addSslHostConfig(sslConfig);
        connector.setPort(port);
        connector.setSecure(true);
        connector.setScheme("https");
        connector.setProperty("SSLEnabled", "true");
        return connector;
    }

    public static Connector getNoSSLConnector(int port) {
        Connector connector = new Connector();
        connector.setPort(port);
        connector.setScheme("http");
        return connector;
    }
}

