/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server;

import com.jsoniter.JsonIterator;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javassist.ClassPool;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.annotations.ScopedServletAnnotationScanner;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authentication.local.LocalAuthSettings;
import net.jami.jams.common.authmodule.AuthenticationModule;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.jami.NameServer;
import net.jami.jams.common.server.ServerSettings;
import net.jami.jams.common.utils.LibraryLoader;
import net.jami.jams.nameserver.LocalNameServer;
import net.jami.jams.nameserver.PublicNameServer;
import net.jami.jams.server.core.TomcatLauncher;
import net.jami.jams.server.licensing.LicenseService;
import net.jami.jams.server.startup.AuthModuleLoader;
import net.jami.jams.server.startup.CryptoEngineLoader;
import net.jami.jams.server.update.JAMSUpdater;
import net.jami.jams.server.update.UpdateInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    public static final AtomicBoolean isInstalled = new AtomicBoolean(false);
    public static final AtomicBoolean activated = new AtomicBoolean(false);
    public static DataStore dataStore;
    public static CertificateAuthority certificateAuthority;
    public static AuthenticationModule userAuthenticationModule;
    public static NameServer nameServer;
    public static TomcatLauncher tomcatLauncher;
    public static LicenseService licenseService;
    public static final UpdateInterface updateInterface;
    public static JAMSUpdater appUpdater;

    public static void main(String[] args) {
        ClassPool.getDefault().clearImportedPackages();
        ScopedServletAnnotationScanner scanner = new ScopedServletAnnotationScanner();
        scanner.processClasses(new File(Server.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName());
        switch (args.length) {
            case 1: {
                tomcatLauncher = new TomcatLauncher(Integer.parseInt(args[0]));
                break;
            }
            case 3: {
                tomcatLauncher = new TomcatLauncher(Integer.parseInt(args[0]), args[1], args[2]);
                break;
            }
            default: {
                log.error("Incorrect number of start arguments provided!");
                System.exit(-1);
            }
        }
        LibraryLoader.loadlibs((String)"libs", Server.class);
        dataStore = new DataStore("jdbc:derby:jams;create=true");
        isInstalled.set(new File(System.getProperty("user.dir") + File.separator + "config.json").exists());
        log.info("Server is already installed: " + isInstalled.get());
        ServerSettings serverSettings = null;
        if (isInstalled.get()) {
            try {
                LocalAuthSettings settings;
                FileInputStream path = new FileInputStream(new File(System.getProperty("user.dir") + File.separator + "config.json"));
                serverSettings = JsonIterator.deserialize(((InputStream)path).readAllBytes(), ServerSettings.class);
                certificateAuthority = CryptoEngineLoader.loadCertificateAuthority(serverSettings.getCaConfiguration(), dataStore);
                userAuthenticationModule = AuthModuleLoader.loadAuthenticationModule(dataStore, certificateAuthority);
                if (serverSettings.getLdapConfiguration() != null) {
                    userAuthenticationModule.attachAuthSource(AuthenticationSourceType.LDAP, serverSettings.getLdapConfiguration());
                }
                if (serverSettings.getActiveDirectoryConfiguration() != null) {
                    userAuthenticationModule.attachAuthSource(AuthenticationSourceType.AD, serverSettings.getActiveDirectoryConfiguration());
                }
                nameServer = serverSettings.getLocalDirectoryConfiguration() != null ? ((settings = JsonIterator.deserialize(serverSettings.getLocalDirectoryConfiguration(), LocalAuthSettings.class)).getPublicNames().booleanValue() ? new PublicNameServer(settings.getPublicNameServer()) : new LocalNameServer(dataStore, userAuthenticationModule, serverSettings.getServerPublicURI())) : new LocalNameServer(dataStore, userAuthenticationModule, serverSettings.getServerPublicURI());
                licenseService.loadLicense();
                log.info("All services are UP and ready for use...");
            }
            catch (Exception e) {
                log.error("Could not load configuration file or initialize some components - this is critical");
            }
        } else {
            certificateAuthority = CryptoEngineLoader.loadCertificateAuthority(null, dataStore);
            userAuthenticationModule = AuthModuleLoader.loadAuthenticationModule(dataStore, certificateAuthority);
            log.info("Started server with empty modules waiting for setup...");
        }
        try {
            Server.startGUI();
        }
        catch (Exception e) {
            log.error("Could not start GUI with error {}", (Object)e.getMessage());
        }
    }

    public static void startGUI() throws Exception {
        boolean ready = false;
        while (!ready) {
            if (userAuthenticationModule.getAuthModulePubKey() == null) continue;
            ready = true;
        }
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(new URI(tomcatLauncher.getTomcat().getConnector().getScheme() + "://localhost:" + tomcatLauncher.getTomcat().getService().findConnectors()[0].getPort()));
        } else {
            log.info("There is no graphical interface on this system - please connect remotely!");
        }
    }

    static {
        tomcatLauncher = null;
        licenseService = new LicenseService();
        updateInterface = new UpdateInterface();
        appUpdater = new JAMSUpdater(new AtomicBoolean(false));
    }
}

