/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.any.NotFoundAny;
import com.jsoniter.output.JsonStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ObjectAny
extends Any {
    private final Map<String, Any> val;

    public ObjectAny(Map<String, Any> val2) {
        this.val = val2;
    }

    @Override
    public ValueType valueType() {
        return ValueType.OBJECT;
    }

    @Override
    public Object object() {
        return this.val;
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        stream.writeObjectStart();
        boolean notFirst = false;
        for (Map.Entry<String, Any> entry : this.val.entrySet()) {
            if (notFirst) {
                stream.writeMore();
            } else {
                notFirst = true;
            }
            stream.writeObjectField(entry.getKey());
            entry.getValue().writeTo(stream);
        }
        stream.writeObjectEnd();
    }

    @Override
    public boolean toBoolean() {
        return !this.val.isEmpty();
    }

    @Override
    public int toInt() {
        return this.size();
    }

    @Override
    public long toLong() {
        return this.size();
    }

    @Override
    public float toFloat() {
        return this.size();
    }

    @Override
    public double toDouble() {
        return this.size();
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.size());
    }

    @Override
    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.size());
    }

    @Override
    public String toString() {
        return JsonStream.serialize(this);
    }

    @Override
    public Any get(Object key) {
        Any element = this.val.get(key);
        if (element == null) {
            return new NotFoundAny(key, this.object());
        }
        return element;
    }

    @Override
    public Any get(Object[] keys, int idx) {
        if (idx == keys.length) {
            return this;
        }
        Object key = keys[idx];
        if (this.isWildcard(key)) {
            HashMap<String, Any> result = new HashMap<String, Any>();
            for (Map.Entry<String, Any> entry : this.val.entrySet()) {
                Any mapped = entry.getValue().get(keys, idx + 1);
                if (mapped.valueType() == ValueType.INVALID) continue;
                result.put(entry.getKey(), mapped);
            }
            return Any.rewrap(result);
        }
        Any element = this.val.get(key);
        if (element == null) {
            return new NotFoundAny(keys, idx, this.object());
        }
        return element.get(keys, idx + 1);
    }

    @Override
    public Any.EntryIterator entries() {
        return new IteratorAdapter(this.val.entrySet().iterator());
    }

    public static class IteratorAdapter
    implements Any.EntryIterator {
        private final Iterator<Map.Entry<String, Any>> iter;
        private Map.Entry<String, Any> entry;

        public IteratorAdapter(Iterator<Map.Entry<String, Any>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean next() {
            if (this.iter.hasNext()) {
                this.entry = this.iter.next();
                return true;
            }
            return false;
        }

        @Override
        public String key() {
            return this.entry.getKey();
        }

        @Override
        public Any value() {
            return this.entry.getValue();
        }
    }
}

