/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.service;

import com.imperva.ddc.core.Connector;
import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.exceptions.GroupDoesNotExistException;
import com.imperva.ddc.core.exceptions.InvalidAuthenticationInfoException;
import com.imperva.ddc.core.exceptions.UserDisabledException;
import com.imperva.ddc.core.language.PhraseOperator;
import com.imperva.ddc.core.language.QueryAssembler;
import com.imperva.ddc.core.language.Sentence;
import com.imperva.ddc.core.language.SentenceOperator;
import com.imperva.ddc.core.query.AccountNameType;
import com.imperva.ddc.core.query.ConnectionResponse;
import com.imperva.ddc.core.query.Cursor;
import com.imperva.ddc.core.query.CursorStatus;
import com.imperva.ddc.core.query.DirectoryType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.EntityResponse;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldType;
import com.imperva.ddc.core.query.ObjectType;
import com.imperva.ddc.core.query.Oops;
import com.imperva.ddc.core.query.PartitionResponse;
import com.imperva.ddc.core.query.QueryRequest;
import com.imperva.ddc.core.query.QueryResponse;
import com.imperva.ddc.core.query.Status;
import com.imperva.ddc.core.query.TestQueryType;
import com.imperva.ddc.service.PagingCallback;
import com.imperva.ddc.service.PagingCallbackContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryConnectorService {
    private static PagingCallback defaultPagingCallback = (data, context) -> true;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryConnectorService.class.getName());

    private DirectoryConnectorService() {
    }

    public static ConnectionResponse authenticate(Endpoint endpoint) {
        ConnectionResponse connectionResponse = null;
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setIgnoreSSLValidations(true);
        queryRequest.addEndpoint(endpoint);
        try (Connector connector = new Connector(queryRequest);){
            connectionResponse = connector.testConnection();
        }
        return connectionResponse;
    }

    public static ConnectionResponse authenticate(Endpoint endpointForAuth, boolean allowEnabledOnly, Endpoint endpoint) {
        String userIdentifier;
        ConnectionResponse response = null;
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setIgnoreSSLValidations(true);
        queryRequest.addEndpoint(endpoint);
        try (Connector connector = new Connector(queryRequest);){
            response = connector.testConnection();
        }
        if (!allowEnabledOnly || response.isError()) {
            return response;
        }
        String string = userIdentifier = endpoint.getOsAccountNameMode() == AccountNameType.DN ? endpoint.getUserAccountName() : endpoint.getOsUserName();
        if (Utils.isEmpty(userIdentifier)) {
            throw new InvalidAuthenticationInfoException("Ldap connection to " + endpointForAuth.getHost() + " failed");
        }
        boolean isEnabled = DirectoryConnectorService.isEnabled(endpointForAuth, userIdentifier);
        if (!isEnabled) {
            boolean noSecondaryError;
            String error = "Ldap Connection to " + endpointForAuth.getHost() + " failed";
            Map<String, Status> statuses = response.getStatuses();
            statuses.put(endpointForAuth.getHost(), new Oops(new UserDisabledException(error)));
            boolean hasSecondary = !Utils.isEmpty(endpointForAuth.getSecondaryHost());
            boolean bl = noSecondaryError = statuses.get(endpointForAuth.getSecondaryHost()) == null;
            if (hasSecondary && noSecondaryError) {
                statuses.put(endpointForAuth.getSecondaryHost(), new Oops(new UserDisabledException(error)));
            }
        }
        return response;
    }

    public static String resolveDistinguishedName(String name, FieldType fieldType, ObjectType objectType, Endpoint endpoint) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(0, name);
        List<String> resolved = DirectoryConnectorService.resolveDistinguishedName(arrayList, fieldType, objectType, endpoint);
        if (!Utils.isEmpty(resolved)) {
            String dn = resolved.get(0).toString();
            return dn;
        }
        return null;
    }

    public static List<String> resolveDistinguishedName(List<String> names, FieldType fieldType, ObjectType objectType, Endpoint endpoint) {
        int maxItemsPerRequest = 100;
        LOGGER.debug("Try to resolve DN of " + names.size() + " entities");
        ArrayList<String> totalMembers = new ArrayList<String>();
        for (int i = 0; i <= names.size(); i += maxItemsPerRequest) {
            int maxTo = i + maxItemsPerRequest;
            int to = names.size() < maxTo ? names.size() : maxTo;
            List<String> namesChunk = names.subList(i, to);
            QueryRequest queryRequest = new QueryRequest();
            queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            endpoints.add(endpoint);
            queryRequest.setEndpoints(endpoints);
            queryRequest.setSizeLimit(1000);
            queryRequest.setTimeLimit(1000);
            queryRequest.setObjectType(objectType);
            queryRequest.setIgnoreSSLValidations(true);
            queryRequest.addRequestedField(FieldType.DISTINGUISHED_NAME);
            QueryAssembler queryAssembler = new QueryAssembler();
            LOGGER.debug("Resolving " + namesChunk.size() + " dns");
            for (String name : namesChunk) {
                LOGGER.trace(name);
                queryAssembler.addPhrase(fieldType, PhraseOperator.EQUAL, name);
            }
            Sentence sentence = queryAssembler.closeSentence(SentenceOperator.OR);
            queryRequest.setSearchSentence(sentence);
            QueryResponse queryResponse = null;
            Connector connector = new Connector(queryRequest);
            Iterator iterator = null;
            try {
                queryResponse = connector.execute();
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (connector != null) {
                    if (iterator != null) {
                        try {
                            connector.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        connector.close();
                    }
                }
            }
            ArrayList result = new ArrayList();
            for (EntityResponse q : queryResponse.getAll()) {
                result.addAll(q.getValue().stream().filter(val2 -> val2.getType() == FieldType.DISTINGUISHED_NAME).map(v -> v.getValue().toString()).collect(Collectors.toList()));
            }
            LOGGER.trace("Resolved DNs:");
            for (String res : result) {
                LOGGER.trace("DN: " + res);
            }
            totalMembers.addAll(result);
        }
        LOGGER.debug("TOTAL DNs resolved " + totalMembers.size());
        return totalMembers;
    }

    public static List<EntityResponse> getEntity(List<String> dns, FieldType fieldType, ObjectType objectType, Endpoint endpoint) {
        int maxItemsPerRequest = 100;
        LOGGER.debug("Try to get entities " + dns.size() + " entities");
        ArrayList<EntityResponse> totalMembers = new ArrayList<EntityResponse>();
        for (int i = 0; i <= dns.size(); i += maxItemsPerRequest) {
            int maxTo = i + maxItemsPerRequest;
            int to = dns.size() < maxTo ? dns.size() : maxTo;
            List<String> namesChunk = dns.subList(i, to);
            QueryRequest queryRequest = new QueryRequest();
            queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            endpoints.add(endpoint);
            queryRequest.setEndpoints(endpoints);
            queryRequest.setSizeLimit(1000);
            queryRequest.setTimeLimit(1000);
            queryRequest.setObjectType(objectType);
            queryRequest.setIgnoreSSLValidations(true);
            queryRequest.addRequestedField(FieldType.LOGON_NAME);
            queryRequest.addRequestedField(FieldType.COMMON_NAME);
            QueryAssembler queryAssembler = new QueryAssembler();
            for (String name : namesChunk) {
                queryAssembler.addPhrase(fieldType, PhraseOperator.EQUAL, name);
            }
            Sentence sentence = queryAssembler.closeSentence(SentenceOperator.OR);
            queryRequest.setSearchSentence(sentence);
            QueryResponse queryResponse = null;
            try (Connector connector = new Connector(queryRequest);){
                queryResponse = connector.execute();
            }
            ArrayList result = new ArrayList();
            totalMembers.addAll(queryResponse.getAll());
            totalMembers.addAll(result);
        }
        return totalMembers;
    }

    public static List<String> isMemberOf(String logonName, List<String> groupsNames, Endpoint endpoint) {
        ArrayList<String> stringList = new ArrayList<String>();
        String distinguishedName = Utils.isDistinguishName(logonName) ? logonName : DirectoryConnectorService.resolveDistinguishedName(logonName, FieldType.LOGON_NAME, ObjectType.USER, endpoint);
        stringList.add(distinguishedName);
        List<EntityResponse> grps = DirectoryConnectorService.doIsMemberOf(stringList, groupsNames, endpoint, null);
        ArrayList<String> memberOf = new ArrayList<String>();
        for (EntityResponse grp : grps) {
            String groupCN = ((Field)grp.getValue().stream().filter(val2 -> val2.getType() == FieldType.COMMON_NAME).collect(Collectors.toList()).get(0)).getValue().toString();
            memberOf.add(groupCN);
        }
        return memberOf;
    }

    public static List<EntityResponse> isMemberOf(List<String> logonName, Endpoint endpoint, PagingCallback pagingCallback) {
        ArrayList<String> dns = new ArrayList<String>();
        ArrayList<String> cns = new ArrayList<String>();
        for (String g : logonName) {
            if (!Utils.isDistinguishName(g)) {
                cns.add(g);
                continue;
            }
            dns.add(g);
        }
        if (!Utils.isEmpty(cns)) {
            List<String> dnsResolved = DirectoryConnectorService.resolveDistinguishedName(cns, FieldType.LOGON_NAME, ObjectType.GROUP, endpoint);
            dns.addAll(dnsResolved);
        }
        if (Utils.isEmpty(dns)) {
            throw new GroupDoesNotExistException("Group {} does not exist in the Active Directory");
        }
        return DirectoryConnectorService.doIsMemberOf(dns, new ArrayList<String>(), endpoint, pagingCallback);
    }

    public static List<EntityResponse> isMemberOf(List<String> logonName, Endpoint endpoint) {
        return DirectoryConnectorService.isMemberOf(logonName, endpoint, defaultPagingCallback);
    }

    private static List<EntityResponse> doIsMemberOf(List<String> dn, List<String> groupsNames, Endpoint endpoint, PagingCallback pagingCallback) {
        LOGGER.debug("Check " + dn + " is member of one or more groups:");
        int maxItemsPerRequest = 100;
        ArrayList<EntityResponse> totalMembers = new ArrayList<EntityResponse>();
        for (int i = 0; i <= dn.size(); i += maxItemsPerRequest) {
            Sentence allEntitiesGroups;
            int maxTo = i + maxItemsPerRequest;
            int to = dn.size() < maxTo ? dn.size() : maxTo;
            List<String> logonNamesChunk = dn.subList(i, to);
            QueryRequest queryRequest = new QueryRequest();
            queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            endpoints.add(new Endpoint(endpoint));
            queryRequest.setEndpoints(endpoints);
            queryRequest.setSizeLimit(1000);
            queryRequest.setTimeLimit(1000);
            queryRequest.setPageChunkSize(1000);
            queryRequest.setObjectType(ObjectType.GROUP);
            queryRequest.addRequestedField(FieldType.COMMON_NAME);
            queryRequest.addRequestedField(FieldType.MEMBER);
            queryRequest.setIgnoreSSLValidations(true);
            QueryAssembler queryAssembler = new QueryAssembler();
            for (String l : logonNamesChunk) {
                queryAssembler.addPhrase(FieldType.GROUP_RECURSIVE, PhraseOperator.EQUAL, l);
            }
            Sentence finalSentence = allEntitiesGroups = queryAssembler.closeSentence(SentenceOperator.OR);
            if (groupsNames != null && groupsNames.size() > 0) {
                for (String g : groupsNames) {
                    LOGGER.debug("Group Name: " + g);
                    queryAssembler.addPhrase(FieldType.COMMON_NAME, PhraseOperator.EQUAL, g);
                }
                Sentence specificGroupsCommonNames = queryAssembler.closeSentence(SentenceOperator.OR);
                finalSentence = queryAssembler.addSentence(allEntitiesGroups).addSentence(specificGroupsCommonNames).closeSentence(SentenceOperator.AND);
            }
            queryRequest.addSearchSentence(finalSentence);
            try (Connector connector = new Connector(queryRequest);){
                Cursor cursor = connector.getCursor();
                QueryResponse queryResponse = new QueryResponse();
                PagingCallbackContext pagingCallbackContext = new PagingCallbackContext();
                while (cursor.hasNext()) {
                    List<PartitionResponse> pp = cursor.next().get();
                    queryResponse.addPartitionResponse(pp);
                    totalMembers.addAll(queryResponse.getAll());
                    if (pagingCallback == null) continue;
                    pagingCallbackContext.setTotal(pagingCallbackContext.getTotal() + queryResponse.getAll().size());
                    boolean isContinue = pagingCallback.callback(queryResponse.getAll(), pagingCallbackContext);
                    queryResponse.get().clear();
                    if (isContinue) continue;
                    List<EntityResponse> list = queryResponse.getAll();
                    return list;
                }
                continue;
            }
        }
        return totalMembers;
    }

    public static List<EntityResponse> getUsersInGroup(List<String> groupNames, List<FieldType> fields, Endpoint endpoint) {
        return DirectoryConnectorService.getUsersInGroup(0, groupNames, fields, endpoint);
    }

    public static List<EntityResponse> getUsersInGroup(List<String> groupNames, Endpoint endpoint) {
        return DirectoryConnectorService.getUsersInGroup(0, groupNames, endpoint);
    }

    public static List<EntityResponse> getUsersInGroup(int maxUsersPerGroup, List<String> groupNames, Endpoint endpoint) {
        return DirectoryConnectorService.getUsersInGroup(maxUsersPerGroup, groupNames, new ArrayList<FieldType>(), endpoint);
    }

    public static List<EntityResponse> getUsersInGroup(int maxUsersPerGroup, List<String> groupNames, List<FieldType> fields, Endpoint endpoint) {
        ArrayList<String> dns = new ArrayList<String>();
        ArrayList<String> cns = new ArrayList<String>();
        for (String g : groupNames) {
            if (!Utils.isDistinguishName(g)) {
                cns.add(g);
                continue;
            }
            dns.add(g);
        }
        if (!Utils.isEmpty(cns)) {
            List<String> dnsResolved = DirectoryConnectorService.resolveDistinguishedName(cns, FieldType.COMMON_NAME, ObjectType.GROUP, endpoint);
            dns.addAll(dnsResolved);
        }
        if (Utils.isEmpty(dns)) {
            throw new GroupDoesNotExistException("Group {} does not exist in the Active Directory");
        }
        return DirectoryConnectorService.getUsersInGroup(maxUsersPerGroup, new LinkedList<String>(dns), fields, endpoint, new HashSet<String>());
    }

    public static List<EntityResponse> getUsersInGroup(String groupName, Endpoint endpoint) {
        return DirectoryConnectorService.getUsersInGroup(0, groupName, endpoint);
    }

    public static List<EntityResponse> getUsersInGroup(int maxUsersPerGroup, String groupName, Endpoint endpoint) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(groupName);
        return DirectoryConnectorService.getUsersInGroup(maxUsersPerGroup, arrayList, endpoint);
    }

    public static EntityResponse getUserByGuid(byte[] guid, Endpoint endpoint) {
        if (Utils.isEmpty(guid)) {
            return null;
        }
        String guidStr = DirectoryConnectorService.convertToByteString(guid);
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.add(endpoint);
        queryRequest.setEndpoints(endpoints);
        queryRequest.setSizeLimit(1000);
        queryRequest.setTimeLimit(1000);
        queryRequest.setObjectType(ObjectType.USER);
        queryRequest.addRequestedField(FieldType.GUID);
        queryRequest.addRequestedField(FieldType.EMAIL);
        queryRequest.addRequestedField(FieldType.COMMON_NAME);
        queryRequest.addRequestedField(FieldType.LOGON_NAME);
        queryRequest.setIgnoreSSLValidations(true);
        Sentence emailByGuid = new QueryAssembler().addPhrase(FieldType.GUID, PhraseOperator.EQUAL, guidStr).closeSentence();
        queryRequest.addSearchSentence(emailByGuid);
        QueryResponse queryResponse = null;
        try (Connector connector = new Connector(queryRequest);){
            queryResponse = connector.execute();
        }
        if (queryResponse.getAll() != null && !queryResponse.getAll().isEmpty()) {
            return queryResponse.getAll().get(0);
        }
        return null;
    }

    public static TestQueryType testQuery(Endpoint endpoint) throws Exception {
        return DirectoryConnectorService.testQuery(endpoint, ObjectType.USER);
    }

    public static TestQueryType testQuery(Endpoint endpoint, ObjectType objectType) throws Exception {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.add(endpoint);
        queryRequest.setEndpoints(endpoints);
        queryRequest.setSizeLimit(1);
        queryRequest.setTimeLimit(1000);
        queryRequest.setObjectType(objectType);
        queryRequest.addRequestedField(FieldType.GUID);
        queryRequest.setIgnoreSSLValidations(true);
        QueryResponse queryResponse = null;
        try (Connector connector = new Connector(queryRequest);){
            queryResponse = connector.execute();
        }
        if (queryResponse.hasError()) {
            PartitionResponse partitionResponse = queryResponse.get().get(0);
            Status status = partitionResponse.getStatus(endpoint.getHost());
            Status statusSecondary = partitionResponse.getStatus(endpoint.getHost());
            if (status != null && status.isError()) {
                throw status.getError();
            }
            if (statusSecondary != null && statusSecondary.isError()) {
                throw statusSecondary.getError();
            }
        } else if (queryResponse.getAll().size() > 0) {
            return TestQueryType.DATA_FOUND;
        }
        return TestQueryType.NO_DATA_FOUND;
    }

    public static ConnectionResponse testConnection(Endpoint endpoint) {
        ConnectionResponse connectionResponse;
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setIgnoreSSLValidations(true);
        queryRequest.addEndpoint(endpoint);
        try (Connector connector = new Connector(queryRequest);){
            connectionResponse = connector.testConnection();
        }
        return connectionResponse;
    }

    public static boolean isEnabled(Endpoint endpoint, String username) {
        String userDN;
        String string = userDN = Utils.isDistinguishName(username) ? username : DirectoryConnectorService.resolveDistinguishedName(username, FieldType.LOGON_NAME, ObjectType.USER, endpoint);
        if (Utils.isEmpty(userDN)) {
            return false;
        }
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.add(endpoint);
        queryRequest.setEndpoints(endpoints);
        queryRequest.setSizeLimit(1);
        queryRequest.setTimeLimit(1000);
        queryRequest.setObjectType(ObjectType.USER);
        queryRequest.setIgnoreSSLValidations(true);
        queryRequest.addRequestedField(FieldType.LOGON_NAME);
        Sentence entity = new QueryAssembler().addPhrase(FieldType.DISTINGUISHED_NAME, PhraseOperator.EQUAL, userDN).addPhrase(FieldType.USER_ACCOUNT_CONTROL_FILTER, PhraseOperator.EQUAL, "2").closeSentence();
        queryRequest.addSearchSentence(entity);
        QueryResponse queryResponse = null;
        try (Connector connector = new Connector(queryRequest);){
            queryResponse = connector.execute();
        }
        return queryResponse.getAll().size() == 0;
    }

    private static String convertToByteString(byte[] objectGUID) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < objectGUID.length; ++i) {
            String transformed = DirectoryConnectorService.prefixZeros(objectGUID[i] & 0xFF);
            result.append("\\");
            result.append(transformed);
        }
        return result.toString();
    }

    private static String prefixZeros(int value) {
        if (value <= 15) {
            StringBuilder sb = new StringBuilder("0");
            sb.append(Integer.toHexString(value));
            return sb.toString();
        }
        return Integer.toHexString(value);
    }

    private static QueryResponse filterUsers(Endpoint endpoint, List<FieldType> fields, Set<String> dns) {
        LOGGER.debug("Filter out users from list of " + dns.size() + " entities");
        QueryResponse allUsers = new QueryResponse();
        ArrayList<String> list = new ArrayList<String>(dns);
        int maxItemsPerRequest = 100;
        for (int i = 0; i <= list.size(); i += maxItemsPerRequest) {
            int maxTo = i + maxItemsPerRequest;
            int to = list.size() < maxTo ? list.size() : maxTo;
            List dnsChucked = list.subList(i, to);
            if (Utils.isEmpty(dnsChucked)) {
                return allUsers;
            }
            QueryRequest queryRequest = new QueryRequest();
            queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            endpoints.add(new Endpoint(endpoint));
            queryRequest.setEndpoints(endpoints);
            queryRequest.setSizeLimit(1000);
            queryRequest.setTimeLimit(1000);
            queryRequest.setPageChunkSize(1000);
            queryRequest.addRequestedField(FieldType.GROUP);
            queryRequest.addRequestedField(FieldType.COMMON_NAME);
            queryRequest.addRequestedField(FieldType.LOGON_NAME);
            queryRequest.setIgnoreSSLValidations(true);
            for (FieldType field : fields) {
                if (field == FieldType.GROUP || field == FieldType.DISTINGUISHED_NAME) continue;
                queryRequest.addRequestedField(field);
            }
            QueryAssembler queryAssembler = new QueryAssembler();
            Sentence userRestrictionSentence = queryAssembler.addPhrase(FieldType.OBJECT_CLASS, PhraseOperator.EQUAL, "person").addPhrase(FieldType.OBJECT_CLASS, PhraseOperator.EQUAL, "user").closeSentence(SentenceOperator.AND);
            for (String res : dnsChucked) {
                queryAssembler.addPhrase(FieldType.DISTINGUISHED_NAME, PhraseOperator.EQUAL, res);
            }
            Sentence dnQuerySentence = queryAssembler.closeSentence(SentenceOperator.OR);
            queryRequest.addSearchSentence(queryAssembler.addSentence(dnQuerySentence).addSentence(userRestrictionSentence).closeSentence(SentenceOperator.AND));
            try (Connector connector = new Connector(queryRequest);){
                Cursor cursor = connector.getCursor();
                while (cursor.hasNext()) {
                    QueryResponse response = cursor.next();
                    LOGGER.debug("Users filtered. Users found: " + response.getAll().size());
                    allUsers.addPartitionResponse(response.get());
                }
            }
            for (EntityResponse user : allUsers.getAll()) {
                LOGGER.trace("User: " + user.toString());
            }
        }
        LOGGER.debug("Total filtered users: " + allUsers.getAll().size());
        return allUsers;
    }

    private static List<EntityResponse> getUsersInGroup(int maxUsersPerGroup, Queue<String> groupNames, List<FieldType> fields, Endpoint endpoint, Set<String> totalResults) {
        boolean isGroupEmpty;
        boolean totalResultsExceeded;
        LOGGER.debug("Get recursively members of " + groupNames.size() + " entities");
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setDirectoryType(DirectoryType.MS_ACTIVE_DIRECTORY);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        endpoints.add(endpoint);
        endpoint.hasNext(CursorStatus.STARTING);
        queryRequest.setEndpoints(endpoints);
        queryRequest.setSizeLimit(1000);
        queryRequest.setTimeLimit(1000);
        queryRequest.setPageChunkSize(1000);
        queryRequest.setIgnoreSSLValidations(true);
        int maxItemsPerRequest = 100;
        QueryAssembler queryAssembler = new QueryAssembler();
        boolean bl = totalResultsExceeded = maxUsersPerGroup > 0 && totalResults.size() >= maxUsersPerGroup;
        if (totalResultsExceeded) {
            LOGGER.debug("About to shrinking total result. Total Results Exceeded (maxUsersPerGroup = " + maxUsersPerGroup + " , totalResults.size() " + totalResults.size() + " )");
            List<EntityResponse> users = DirectoryConnectorService.filterUsers(endpoint, fields, totalResults).getAll();
            LOGGER.debug("Rechecking Total Results Exceeded (" + users.size() + ").");
            if (users.size() >= maxUsersPerGroup) {
                LOGGER.debug("Exceeded! Sublisting users list to " + users.size());
                users = users.subList(0, maxUsersPerGroup);
                return users;
            }
            LOGGER.debug("After shrinking total result size is " + users.size() + ". Continuing executing the recursion");
            HashSet<String> usersDNs = new HashSet<String>();
            for (EntityResponse res : users) {
                usersDNs.add((String)res.getKey());
            }
            totalResults = usersDNs;
        }
        boolean bl2 = isGroupEmpty = groupNames == null || groupNames.isEmpty();
        if (isGroupEmpty) {
            if (Utils.isEmpty(totalResults)) {
                return new ArrayList<EntityResponse>();
            }
            LOGGER.debug("No more members could be found. Exiting from recursion");
            return DirectoryConnectorService.filterUsers(endpoint, fields, totalResults).getAll();
        }
        queryRequest.addRequestedField(FieldType.COMMON_NAME);
        queryRequest.addRequestedField(FieldType.MEMBER);
        queryRequest.addRequestedField(FieldType.OBJECT_CLASS);
        LinkedList<String> partialNamesQueue = new LinkedList<String>();
        int to = groupNames.size() < maxItemsPerRequest ? groupNames.size() : maxItemsPerRequest;
        for (int i = 1; i <= to; ++i) {
            partialNamesQueue.add(groupNames.poll());
        }
        for (String groupName : partialNamesQueue) {
            LOGGER.trace("Group Name: " + groupName);
            queryAssembler.addPhrase(FieldType.DISTINGUISHED_NAME, PhraseOperator.EQUAL, groupName);
        }
        Sentence dnQuerySentence = queryAssembler.closeSentence(SentenceOperator.OR);
        Sentence groupRestrictionSentence = queryAssembler.addPhrase(FieldType.OBJECT_CLASS, PhraseOperator.EQUAL, "group").closeSentence(SentenceOperator.EMPTY);
        queryRequest.addSearchSentence(queryAssembler.addSentence(dnQuerySentence).addSentence(groupRestrictionSentence).closeSentence(SentenceOperator.AND));
        QueryResponse queryResponse = new QueryResponse();
        try (Connector connector = new Connector(queryRequest);){
            Cursor cursor = connector.getCursor();
            while (cursor.hasNext()) {
                queryResponse.addPartitionResponse(cursor.next().get());
            }
        }
        for (EntityResponse res : queryResponse.getAll()) {
            Iterator iterator = res.getValue().iterator();
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (field.getType() != FieldType.MEMBER || !totalResults.add(field.getValue().toString())) continue;
                groupNames.add(field.getValue().toString());
            }
        }
        return DirectoryConnectorService.getUsersInGroup(maxUsersPerGroup, groupNames, fields, endpoint, totalResults);
    }
}

