/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.query;

import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.language.PhraseOperator;
import com.imperva.ddc.core.language.QueryAssembler;
import com.imperva.ddc.core.language.Sentence;
import com.imperva.ddc.core.language.SentenceOperator;
import com.imperva.ddc.core.language.Word;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldType;
import com.imperva.ddc.core.query.ObjectType;
import com.imperva.ddc.core.query.ReferralsHandling;
import com.imperva.ddc.core.query.Request;
import java.util.ArrayList;
import java.util.List;

public class QueryRequest
extends Request {
    private ObjectType objectType;
    private List<Field> requestedFields = new ArrayList<Field>();
    private Sentence searchSentence = null;
    private String searchText;
    private ReferralsHandling referralsHandling;
    private Integer sizeLimit = 1000;
    private Integer timeLimit = 30;
    private int pageChunkSize;
    private String searchSentenceText;
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();

    public int getPageChunkSize() {
        return this.pageChunkSize;
    }

    public void setPageChunkSize(int pageChunkSize) {
        this.pageChunkSize = pageChunkSize;
    }

    public void setObjectType(ObjectType objectType) {
        Sentence baseSentence = this.createBaseSentence(objectType);
        this.addSearchSentence(baseSentence);
        this.objectType = objectType;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setRequestedFields(List<Field> fields) {
        this.requestedFields = fields;
    }

    public List<Field> getRequestedFields() {
        return this.requestedFields;
    }

    public void setSearchSentence(Sentence searchSentences) {
        this.searchSentence = searchSentences;
    }

    public Sentence getSearchSentence() {
        return this.searchSentence;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getSearchSentenceText() {
        return this.searchSentenceText;
    }

    public void setSearchSentenceText(String searchSentenceText) {
        this.searchSentenceText = searchSentenceText;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public ReferralsHandling getReferralsHandling() {
        return this.referralsHandling;
    }

    public void setReferralsHandling(ReferralsHandling referralsHandling) {
        this.referralsHandling = referralsHandling;
    }

    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public Integer getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }

    public QueryRequest addRequestedField(String fieldName) {
        Field field = new Field();
        field.setName(fieldName);
        this.requestedFields.add(field);
        return this;
    }

    public QueryRequest addRequestedField(FieldType fieldType) {
        Field field = new Field();
        field.setType(fieldType);
        this.requestedFields.add(field);
        return this;
    }

    public boolean isPaged() {
        return this.getPageChunkSize() > 0;
    }

    public QueryRequest addEndpoint(Endpoint endpoint) {
        if (this.endpoints != null) {
            this.endpoints.add(endpoint);
        }
        return this;
    }

    Sentence createBaseSentence(ObjectType objectType) {
        Sentence baseFilterSentence;
        QueryAssembler queryAssembler = this.queryAssemblerGetInstance();
        switch (objectType) {
            case USER: {
                baseFilterSentence = queryAssembler.addPhrase(FieldType.OBJECT_CLASS, PhraseOperator.EQUAL, "user").addPhrase(FieldType.OBJECT_CATEGORY, PhraseOperator.EQUAL, "person").closeSentence(SentenceOperator.AND);
                break;
            }
            case GROUP: {
                baseFilterSentence = queryAssembler.addPhrase(FieldType.OBJECT_CLASS, PhraseOperator.EQUAL, "group").closeSentence(SentenceOperator.EMPTY);
                break;
            }
            case COMPUTER: {
                return null;
            }
            case PRINTER: {
                return null;
            }
            case ALL: {
                return null;
            }
            default: {
                return null;
            }
        }
        return baseFilterSentence;
    }

    public void addSearchSentence(Sentence searchSentences) {
        Sentence fullSentence;
        this.searchSentence = this.searchSentence == null ? searchSentences : (fullSentence = this.queryAssemblerGetInstance().appendSentence(searchSentences, this.getSearchSentence()));
    }

    public Word find(String id) {
        Sentence sentence = this.getSearchSentence();
        return this.find(id, sentence);
    }

    Word find(String id, Word nextWord) {
        if (nextWord != null && nextWord.getId().equals(id)) {
            return nextWord;
        }
        if (nextWord == null) {
            return null;
        }
        if (nextWord instanceof Sentence) {
            Sentence sentence = (Sentence)nextWord;
            for (Word word : sentence.getSentences()) {
                Word detectedWord = this.find(id, word);
                if (detectedWord == null) continue;
                return detectedWord;
            }
        }
        return null;
    }

    QueryAssembler queryAssemblerGetInstance() {
        return new QueryAssembler();
    }

    @Override
    public void close() {
        if (!Utils.isEmpty(this.endpoints)) {
            this.endpoints.forEach(e -> {
                if (e != null) {
                    e.close();
                    e.setLdapConnection(null);
                    e.setDestinationType(DestinationType.NONE);
                }
            });
        }
    }
}

