/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.query;

import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Status;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.ldap.client.api.LdapConnection;

public class LdapConnectionResult {
    LdapConnection connection;
    DestinationType destinationType;
    Map<String, Status> statuses = new HashMap<String, Status>();

    public void setDestinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public boolean hasError() {
        for (Map.Entry<String, Status> entry : this.statuses.entrySet()) {
            if (!entry.getValue().isError()) continue;
            return true;
        }
        return false;
    }

    public LdapConnection getConnection() {
        return this.connection;
    }

    public void setConnection(LdapConnection connection) {
        this.connection = connection;
    }

    public Map<String, Status> getStatuses() {
        return this.statuses;
    }

    public void addStatus(String host, Status status) {
        if (Utils.isEmpty(host) || status == null) {
            throw new RuntimeException("Host and Status can't be empty");
        }
        this.statuses.put(host, status);
    }

    public void setStatuses(Map<String, Status> statuses) {
        this.statuses = statuses;
    }

    public boolean connectionSucceeded() {
        return this.connection != null && this.connection.isConnected();
    }

    public void addStatus(Map<String, Status> statuses) {
        this.statuses.putAll(statuses);
    }
}

