/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core.query;

import com.imperva.ddc.core.language.changeCreteria.ChangeCriteria;
import com.imperva.ddc.core.query.ChangeRequest;
import com.imperva.ddc.core.query.Field;
import com.imperva.ddc.core.query.FieldType;
import com.imperva.ddc.core.query.ModificationDetails;
import com.imperva.ddc.core.query.RequestBuilder;
import java.util.List;

public class ChangeCriteriaBuilder
extends RequestBuilder {
    private ChangeRequest changeRequest;
    List<ModificationDetails> modificationDetailsList;

    public ChangeRequest getChangeRequest() {
        return this.changeRequest;
    }

    public void setChangeRequest(ChangeRequest changeRequest) {
        this.changeRequest = changeRequest;
    }

    public void translateChangeFields() {
        List<ModificationDetails> modificationDetailsList = this.getChangeRequest().getModificationDetailsList();
        for (ModificationDetails modificationDetails : modificationDetailsList) {
            this.translateField(modificationDetails.getAttribute());
        }
    }

    public ChangeCriteria get() {
        ChangeCriteria changeCriteria = new ChangeCriteria();
        changeCriteria.setModificationDetailsList(this.changeRequest.getModificationDetailsList());
        return changeCriteria;
    }

    @Override
    public void translateFilter() {
        if (this.modificationDetailsList == null && this.modificationDetailsList.isEmpty()) {
            return;
        }
        Field dnField = new Field();
        dnField.setType(FieldType.DISTINGUISHED_NAME);
        for (ModificationDetails modificationDetails : this.modificationDetailsList) {
            modificationDetails.setDn(ChangeCriteriaBuilder.escapeSpecialChars(modificationDetails.getDn(), dnField));
        }
    }
}

