/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.Driver;
import com.imperva.ddc.core.DriverBase;
import com.imperva.ddc.core.DriverHostResolverDecorator;
import com.imperva.ddc.core.DriverRobustDecorator;
import com.imperva.ddc.core.exceptions.BaseException;
import com.imperva.ddc.core.exceptions.RemoveRequestFailedException;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.LdapConnectionResult;
import com.imperva.ddc.core.query.RemoveRequest;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveRequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveRequestExecutor.class.getName());
    RemoveRequest removeRequest;

    public RemoveRequestExecutor(RemoveRequest removeRequest) {
        this.removeRequest = removeRequest;
    }

    void execute() {
        Endpoint endpoint = this.removeRequest.getEndpoint();
        String host = endpoint.getHost();
        try {
            LOGGER.debug("Executing request for: " + host);
            LdapConnectionResult ldapConnectionResult = this.driverGetInstance().connect(endpoint);
            ldapConnectionResult.getConnection().delete(this.removeRequest.getDn());
        }
        catch (BaseException | LdapException e) {
            LOGGER.error("Remove Execution failed for Endpoint: " + host, e);
            endpoint.setDestinationType(DestinationType.NONE);
            throw new RemoveRequestFailedException(e.getMessage(), host);
        }
    }

    DriverBase driverGetInstance() {
        return new DriverHostResolverDecorator(new DriverRobustDecorator(new Driver()));
    }
}

