/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.ApacheAPIConverter;
import com.imperva.ddc.core.Driver;
import com.imperva.ddc.core.DriverBase;
import com.imperva.ddc.core.DriverHostResolverDecorator;
import com.imperva.ddc.core.DriverRobustDecorator;
import com.imperva.ddc.core.exceptions.BaseException;
import com.imperva.ddc.core.exceptions.ChangeRequestFailedException;
import com.imperva.ddc.core.query.ChangeRequest;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.LdapConnectionResult;
import com.imperva.ddc.core.query.ModificationDetails;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeRequestExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeRequestExecutor.class.getName());
    ChangeRequest changeRequest;
    ApacheAPIConverter apacheAPIConverter = new ApacheAPIConverter();

    public ChangeRequestExecutor(ChangeRequest changeRequest) {
        this.changeRequest = changeRequest;
    }

    void execute() {
        Endpoint endpoint = this.changeRequest.getEndpoint();
        String host = endpoint.getHost();
        try {
            LOGGER.debug("Executing request for: " + host);
            LdapConnectionResult ldapConnectionResult = this.driverGetInstance().connect(endpoint);
            for (ModificationDetails modificationDetails : this.changeRequest.getModificationDetailsList()) {
                Modification modification = this.apacheAPIConverter.toModification(modificationDetails);
                ldapConnectionResult.getConnection().modify(modificationDetails.getDn(), modification);
            }
        }
        catch (BaseException | LdapException e) {
            LOGGER.error("Change Execution failed for Endpoint: " + host, e);
            endpoint.setDestinationType(DestinationType.NONE);
            throw new ChangeRequestFailedException(e.getMessage(), host);
        }
    }

    DriverBase driverGetInstance() {
        return new DriverHostResolverDecorator(new DriverRobustDecorator(new Driver()));
    }
}

