/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.update;

import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jami.jams.common.updater.AppUpdater;
import net.jami.jams.common.updater.FileDescription;
import net.jami.jams.server.Server;
import net.jami.jams.server.update.UpdateCheckTask;
import net.jami.jams.server.update.UpdateDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAMSUpdater
implements AppUpdater {
    private static final Logger log = LoggerFactory.getLogger(JAMSUpdater.class);
    protected static volatile String UPDATE_SERVER_URI;
    private static volatile Long UPDATE_INTERVAL;
    public static final AtomicBoolean updateAvailable;
    private final AtomicBoolean doUpdate;
    private final UpdateCheckTask updateCheckTask = new UpdateCheckTask();
    private final UpdateDownloader updateDownloader = new UpdateDownloader();
    private final Timer timer = new Timer();
    public static volatile X509Certificate certificate;
    public static volatile PrivateKey privateKey;

    public JAMSUpdater(AtomicBoolean doUpdate) {
        try {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("oem/config.json");
            Any any = JsonIterator.deserialize(input.readAllBytes());
            UPDATE_SERVER_URI = any.get((Object)"UPDATE_URL").toString();
            UPDATE_INTERVAL = any.get((Object)"UPDATE_INTERVAL").toLong();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.doUpdate = doUpdate;
        this.timer.schedule((TimerTask)this.updateCheckTask, 0L, (long)UPDATE_INTERVAL);
    }

    @Override
    public HashMap<String, FileDescription> getLocalVersions() {
        return this.updateCheckTask.getLocalData();
    }

    @Override
    public HashMap<String, FileDescription> getRemoteVersions() {
        return this.updateCheckTask.getRemoteData();
    }

    @Override
    public boolean getUpdateAvailable() {
        return updateAvailable.get();
    }

    @Override
    public void setLicense(X509Certificate certificate, PrivateKey privateKey) {
        JAMSUpdater.certificate = certificate;
        JAMSUpdater.privateKey = privateKey;
    }

    @Override
    public void doUpdate() {
        boolean res = this.updateDownloader.downloadFiles(this.getRemoteVersions());
        if (res) {
            Server.updateInterface.approveUpdate();
        } else {
            log.error("Could not perform update - the downloaded files may have been invalid!");
        }
    }

    public AtomicBoolean getDoUpdate() {
        return this.doUpdate;
    }

    public UpdateCheckTask getUpdateCheckTask() {
        return this.updateCheckTask;
    }

    public UpdateDownloader getUpdateDownloader() {
        return this.updateDownloader;
    }

    public Timer getTimer() {
        return this.timer;
    }

    static {
        updateAvailable = new AtomicBoolean(false);
    }
}

