/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.x509;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.server.Server;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;

@WebServlet(value={"/api/ocsp"})
public class OCSPServlet
extends HttpServlet {
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/ocsp-response");
        byte[] content = new byte[Integer.parseInt(req.getHeader("Content-Length"))];
        try {
            for (int i = 0; i < content.length; ++i) {
                req.getInputStream().read(content);
            }
            OCSPReq ocspReq = new OCSPReq(content);
            OCSPResp ocspResp = Server.certificateAuthority.getOCSPResponse(ocspReq);
            if (ocspResp != null) {
                byte[] respBytes = ocspResp.getEncoded();
                resp.getOutputStream().write(respBytes);
            } else {
                resp.setStatus(404);
            }
        }
        catch (Exception e) {
            resp.sendError(404, "Could not find the requested certificate!");
        }
    }
}

