/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.install;

import com.jsoniter.JsonIterator;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.cryptoengineapi.CertificateAuthorityConfig;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.core.workflows.InstallationFinalizer;
import net.jami.jams.server.servlets.api.install.CachedObjects;

@WebServlet(value={"/api/install/settings"})
public class CreateServerSettingsServlet
extends HttpServlet {
    InstallationFinalizer finalizer = new InstallationFinalizer();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        super.doGet(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        CertificateAuthorityConfig config;
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        CachedObjects.certificateAuthorityConfig = config = JsonIterator.deserialize(req.getInputStream().readAllBytes(), CertificateAuthorityConfig.class);
        if (!this.finalizer.finalizeInstallation()) {
            resp.sendError(500, "Could not store settings, a problem occured with finishing the installation");
            return;
        }
        resp.setStatus(200);
    }
}

