/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.install;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.objects.requests.CreateAuthSourceRequest;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.api.install.CachedObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/install/auth"})
public class CreateAuthSourceServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CreateAuthSourceServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        super.doGet(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        CreateAuthSourceRequest authSourceRequest = JsonIterator.deserialize(req.getInputStream().readAllBytes(), CreateAuthSourceRequest.class);
        CachedObjects.localAuthSettings = null;
        CachedObjects.activeDirectorySettings = null;
        CachedObjects.ldapSettings = null;
        boolean error = false;
        switch (authSourceRequest.getType()) {
            case LOCAL: {
                CachedObjects.localAuthSettings = authSourceRequest.getLocalAuthSettings();
                break;
            }
            case LDAP: {
                if (Server.userAuthenticationModule.testModuleConfiguration(AuthenticationSourceType.LDAP, JsonStream.serialize(authSourceRequest.getLdapSettings()))) {
                    CachedObjects.ldapSettings = authSourceRequest.getLdapSettings();
                    break;
                }
                error = true;
                break;
            }
            case AD: {
                if (Server.userAuthenticationModule.testModuleConfiguration(AuthenticationSourceType.AD, JsonStream.serialize(authSourceRequest.getActiveDirectorySettings()))) {
                    CachedObjects.activeDirectorySettings = authSourceRequest.getActiveDirectorySettings();
                    break;
                }
                error = true;
            }
        }
        if (error) {
            resp.sendError(500, "The supplied configuration is invalid or the connectivity tests has failed");
        } else {
            CachedObjects.endpoint = "/api/install/settings";
        }
    }
}

