/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.user;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/auth/user"})
public class UserServlet
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        StatementList statementList = new StatementList();
        StatementElement st = new StatementElement("username", "=", req.getAttribute("username").toString(), "");
        statementList.addStatement(st);
        if (!Server.dataStore.getUserDao().getObjects(statementList).isEmpty()) {
            User user = (User)Server.dataStore.getUserDao().getObjects(statementList).get(0);
            if (Server.certificateAuthority.getLatestCRL().get() != null) {
                user.setRevoked(Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(user.getCertificate().getSerialNumber()) != null);
            } else {
                user.setRevoked(false);
            }
            resp.setStatus(200);
            resp.getOutputStream().write(JsonStream.serialize(user).getBytes());
        } else {
            resp.sendError(404, "User was not found!");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getAttribute("username").toString();
        StatementList select = new StatementList();
        StatementElement st = new StatementElement("username", "=", username, "");
        select.addStatement(st);
        if (((User)Server.dataStore.getUserDao().getObjects(select).get(0)).getUserType() != AuthenticationSourceType.LOCAL) {
            resp.sendError(403, "The user is not a local user, therefore we cannot change his data!");
            return;
        }
        StatementList update = new StatementList();
        StatementElement st0 = new StatementElement("password", "=", req.getParameter("password"), "");
        update.addStatement(st0);
        StatementList constraint = new StatementList();
        StatementElement st1 = new StatementElement("username", "=", username, "");
        constraint.addStatement(st1);
        if (Server.dataStore.getUserDao().updateObject(update, constraint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "could not update the users's data field!");
        }
    }
}

