/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.directory;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/auth/directory/entry"})
public class DirectoryEntryServlet
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("jamiId") != null) {
            StatementList statementList = new StatementList();
            StatementElement statementElement = new StatementElement("jamiId", "=", req.getParameter("jamiId"), null);
            statementList.addStatement(statementElement);
            User user = (User)Server.dataStore.getUserDao().getObjects(statementList).get(0);
            ArrayList userProfiles = new ArrayList();
            Server.userAuthenticationModule.getAuthSources().forEach((k, v) -> userProfiles.addAll(v.searchUserProfiles(user.getUsername(), "LOGON_NAME", Optional.empty())));
            if (req.getParameter("format") != null && req.getParameter("format").equals("vcard")) {
                resp.getOutputStream().write(((UserProfile)userProfiles.get(0)).getAsVCard().getBytes());
            } else {
                resp.getOutputStream().write(JsonStream.serialize(userProfiles.get(0)).getBytes());
            }
            return;
        }
        if (req.getParameter("directory") != null && req.getParameter("directoryType") != null) {
            List<UserProfile> profiles = Server.userAuthenticationModule.getAuthSources().get(new AuthModuleKey(req.getParameter("directory"), AuthenticationSourceType.fromString(req.getParameter("directoryType")))).searchUserProfiles(req.getParameter("username"), "LOGON_NAME", Optional.empty());
            if (req.getParameter("format") != null && req.getParameter("format").equals("vcard")) {
                resp.getOutputStream().write(profiles.get(0).getAsVCard().getBytes());
            } else {
                resp.getOutputStream().write(JsonStream.serialize(profiles.get(0)).getBytes());
            }
            return;
        }
        ArrayList userProfiles = new ArrayList();
        Server.userAuthenticationModule.getAuthSources().forEach((k, v) -> userProfiles.addAll(v.searchUserProfiles(req.getParameter("username"), "LOGON_NAME", Optional.empty())));
        if (req.getParameter("format") != null && req.getParameter("format").equals("vcard")) {
            resp.getOutputStream().write(((UserProfile)userProfiles.get(0)).getAsVCard().getBytes());
        } else {
            resp.getOutputStream().write(JsonStream.serialize(userProfiles.get(0)).getBytes());
        }
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }
}

