/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.device;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/auth/devices"})
public class DevicesServlet
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("owner", "=", username, ""));
        List<Device> devices = Server.dataStore.getDeviceDao().getObjects(statementList);
        if (Server.certificateAuthority.getLatestCRL() != null) {
            devices.forEach(device -> device.setRevoked(Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(device.getCertificate().getSerialNumber()) != null));
        } else {
            devices.forEach(device -> device.setRevoked(false));
        }
        resp.getOutputStream().write(JsonStream.serialize(devices).getBytes());
        resp.setStatus(200);
    }
}

