/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/group/*"})
public class GroupProfileServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GroupProfileServlet.class);

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        List<Object> groups = new ArrayList();
        Group singleGroup = null;
        String groupName = req.getPathInfo().replace("/", "");
        if (!groupName.equals("*")) {
            StatementList statementList = new StatementList();
            StatementElement st = new StatementElement("name", "=", groupName, "");
            statementList.addStatement(st);
            if (!Server.dataStore.getGroupDao().getObjects(statementList).isEmpty()) {
                singleGroup = (Group)Server.dataStore.getGroupDao().getObjects(statementList).get(0);
            }
        } else {
            groups = Server.dataStore.getGroupDao().getObjects(null);
        }
        if (singleGroup != null) {
            Group finalSingleGroup = singleGroup;
            List<UserProfile> profiles = Server.dataStore.getUserProfileDao().getObjects(null).stream().filter(profile -> profile.getGroupMemberships().contains(finalSingleGroup.getName())).collect(Collectors.toList());
            profiles.forEach(profile -> finalSingleGroup.getGroupMembers().add(profile.getUsername()));
            resp.getOutputStream().write(JsonStream.serialize(finalSingleGroup).getBytes());
            resp.setStatus(200);
        }
        if (!groups.isEmpty()) {
            List profiles = Server.dataStore.getUserProfileDao().getObjects(null);
            for (Group group : groups) {
                for (UserProfile p : profiles) {
                    if (!p.getGroupMemberships().contains(group.getName())) continue;
                    group.getGroupMembers().add(p.getUsername());
                }
            }
            resp.getOutputStream().write(JsonStream.serialize(groups).getBytes());
            resp.setStatus(200);
        } else {
            log.info("No existing groups were found.");
            resp.setStatus(200);
        }
    }
}

