/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.fs;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public abstract class FileStorage<T> {
    private File file;
    private FileInputStream fileInputStream;
    private FileOutputStream fileOutputStream;
    private FileDescriptor fileDescriptor;

    public FileStorage(String file) {
        this.file = new File(file);
    }

    public abstract T getObject(byte[] var1) throws Exception;

    public abstract byte[] getBytesFromObject(T var1) throws Exception;

    public T getData() throws Exception {
        this.fileInputStream = new FileInputStream(this.file);
        return this.getObject(this.fileInputStream.readAllBytes());
    }

    public void storeData(T data) throws Exception {
        this.fileOutputStream = new FileOutputStream(this.file);
        this.fileDescriptor = this.fileOutputStream.getFD();
        this.fileOutputStream.write(this.getBytesFromObject(data));
        this.fileOutputStream.flush();
        this.fileDescriptor.sync();
    }

    public File getFile() {
        return this.file;
    }

    public FileInputStream getFileInputStream() {
        return this.fileInputStream;
    }

    public FileOutputStream getFileOutputStream() {
        return this.fileOutputStream;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileInputStream(FileInputStream fileInputStream) {
        this.fileInputStream = fileInputStream;
    }

    public void setFileOutputStream(FileOutputStream fileOutputStream) {
        this.fileOutputStream = fileOutputStream;
    }

    public void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }
}

