/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.decoders;

import com.jsoniter.JsonIterator;
import com.jsoniter.spi.Decoder;
import java.io.IOException;
import net.jami.jams.common.utils.X509Utils;

public class CSRDecoder
implements Decoder {
    private static final String CSR_HEAD = "-----BEGIN NEW CERTIFICATE REQUEST-----\n";
    private static final String CSR_TAIL = "\n-----END NEW CERTIFICATE REQUEST-----";

    @Override
    public Object decode(JsonIterator jsonIterator) throws IOException {
        Object input = jsonIterator.readString();
        if (input == null) {
            return null;
        }
        input = ((String)input).replace(CSR_HEAD, "");
        input = ((String)input).replace(CSR_TAIL, "");
        input = ((String)input).replace("\n", "");
        input = CSR_HEAD + (String)input + CSR_TAIL;
        return X509Utils.getCSRFromString((String)input);
    }
}

