/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.objects.devices;

import com.jsoniter.annotation.JsonIgnore;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.jami.jams.common.objects.roots.X509Entity;
import net.jami.jams.common.serialization.database.DatabaseObject;
import net.jami.jams.common.utils.X509Utils;

public class Device
extends X509Entity
implements DatabaseObject {
    private String deviceId;
    @JsonIgnore
    private String owner;
    private String displayName;

    public Device(ResultSet rs) throws Exception {
        this.deviceId = rs.getString("deviceId");
        this.owner = rs.getString("owner");
        this.displayName = rs.getString("displayName");
        this.setCertificate(X509Utils.getCertificateFromPEMString(rs.getString("certificate")));
        this.setPrivateKey(X509Utils.getKeyFromPEMString(rs.getString("privatekey")));
    }

    @Override
    public PreparedStatement getInsert(PreparedStatement ps) throws Exception {
        ps.setString(1, this.deviceId);
        ps.setString(2, this.owner);
        ps.setString(3, this.displayName);
        ps.setString(4, X509Utils.getPEMStringFromCertificate(this.getCertificate()));
        ps.setString(5, "");
        return ps;
    }

    @Override
    public PreparedStatement getDelete(PreparedStatement ps) throws Exception {
        return null;
    }

    @Override
    public PreparedStatement getUpdate(PreparedStatement ps) throws Exception {
        return null;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Device() {
    }

    public Device(String deviceId, String owner, String displayName) {
        this.deviceId = deviceId;
        this.owner = owner;
        this.displayName = displayName;
    }
}

