/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.dao;

import java.sql.PreparedStatement;
import net.jami.jams.common.dao.StatementConstraints;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;

public class SelectStatementBuilder {
    public static PreparedStatement buildStatement(String table, StatementList statementElements, StatementConstraints statementConstraints, SQLConnection connection) throws Exception {
        PreparedStatement ps = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * FROM ").append(table);
        if (statementElements != null) {
            stringBuilder.append(" WHERE ");
            for (StatementElement statementElement : statementElements.getStatements()) {
                stringBuilder.append("lower(" + statementElement.getColumn() + ")").append(" ").append(statementElement.getOperator()).append(" ").append("?").append(" ").append(statementElement.getNextStatementRelation()).append(" ");
            }
            ps = connection.getConnection().prepareStatement(stringBuilder.toString());
            int i = 1;
            for (StatementElement statementElement : statementElements.getStatements()) {
                ps.setString(i, statementElement.getValue().toLowerCase());
                ++i;
            }
        } else {
            if (statementConstraints != null) {
                stringBuilder.append(" LIMIT ").append(statementConstraints.getRowCount()).append(" OFFSET ").append(statementConstraints.getOffset());
            }
            ps = connection.getConnection().prepareStatement(stringBuilder.toString());
        }
        return ps;
    }
}

