/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.cryptoengineapi.ocsp;

import java.util.HashMap;

public enum RevocationReason {
    UNSPECIFIED(0, "unspecified"),
    KEY_COMPROMISE(1, "keyCompromise"),
    CA_COMPROMISE(2, "CACompromise"),
    AFFILIATION_CHANGED(3, "affiliationChanged"),
    SUPERSEDED(4, "superseded"),
    CESSATION_OF_OPERATION(5, "cessationOfOperation"),
    CERTIFICATE_HOLD(6, "certificateHold"),
    UNUSED(7, "unused"),
    REMOVE_FROM_CRL(8, "removeFromCRL"),
    PRIVILEGE_WITHDRAWN(9, "privilegeWithdrawn"),
    AA_COMPROMISE(10, "AACompromise");

    private static final int NUM_CODES = 11;
    private int code;
    private String name;
    private static HashMap<String, RevocationReason> nameToReason;

    private RevocationReason(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static RevocationReason fromCode(int code) {
        if (code > 10 || code < 0 || code == 7) {
            throw new IllegalArgumentException("CRL Reason code not recognized: " + code);
        }
        return RevocationReason.values()[code];
    }

    public static void initMap() {
        nameToReason.put(UNSPECIFIED.getName(), UNSPECIFIED);
        nameToReason.put(KEY_COMPROMISE.getName(), KEY_COMPROMISE);
        nameToReason.put(CA_COMPROMISE.getName(), CA_COMPROMISE);
        nameToReason.put(AFFILIATION_CHANGED.getName(), AFFILIATION_CHANGED);
        nameToReason.put(SUPERSEDED.getName(), SUPERSEDED);
        nameToReason.put(CESSATION_OF_OPERATION.getName(), CESSATION_OF_OPERATION);
        nameToReason.put(CERTIFICATE_HOLD.getName(), CERTIFICATE_HOLD);
        nameToReason.put(REMOVE_FROM_CRL.getName(), REMOVE_FROM_CRL);
        nameToReason.put(PRIVILEGE_WITHDRAWN.getName(), PRIVILEGE_WITHDRAWN);
        nameToReason.put(AA_COMPROMISE.getName(), AA_COMPROMISE);
    }

    public static RevocationReason fromName(String name) {
        return nameToReason.get(name);
    }

    static {
        nameToReason = new HashMap();
    }
}

