/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.cryptoengineapi.ocsp;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.security.auth.x500.X500Principal;
import net.jami.jams.common.cryptoengineapi.ocsp.CertificateStatus;
import net.jami.jams.common.cryptoengineapi.ocsp.RevocationReason;

public class CertificateSummary {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMddHHmmssZ");
    private CertificateStatus status;
    private LocalDateTime expirationTime;
    private LocalDateTime revocationTime;
    private RevocationReason revocationReason;
    private BigInteger serialNumber;
    private String fileName;
    private X500Principal subjectDN;

    public CertificateSummary(CertificateStatus status, LocalDateTime revocationTime, BigInteger serialNumber) {
        this.status = status;
        this.revocationTime = revocationTime;
        this.serialNumber = serialNumber;
    }

    public CertificateSummary(CertificateStatus status, BigInteger serialNumber) {
        this.status = status;
        this.serialNumber = serialNumber;
    }

    public CertificateStatus getStatus() {
        return this.status;
    }

    public LocalDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public LocalDateTime getRevocationTime() {
        return this.revocationTime;
    }

    public RevocationReason getRevocationReason() {
        return this.revocationReason;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public X500Principal getSubjectDN() {
        return this.subjectDN;
    }

    public void setStatus(CertificateStatus status) {
        this.status = status;
    }

    public void setExpirationTime(LocalDateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setRevocationTime(LocalDateTime revocationTime) {
        this.revocationTime = revocationTime;
    }

    public void setRevocationReason(RevocationReason revocationReason) {
        this.revocationReason = revocationReason;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSubjectDN(X500Principal subjectDN) {
        this.subjectDN = subjectDN;
    }

    public CertificateSummary() {
    }

    public CertificateSummary(CertificateStatus status, LocalDateTime expirationTime, LocalDateTime revocationTime, RevocationReason revocationReason, BigInteger serialNumber, String fileName, X500Principal subjectDN) {
        this.status = status;
        this.expirationTime = expirationTime;
        this.revocationTime = revocationTime;
        this.revocationReason = revocationReason;
        this.serialNumber = serialNumber;
        this.fileName = fileName;
        this.subjectDN = subjectDN;
    }
}

