/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca.workers.csr;

import net.jami.jams.ca.workers.csr.builders.DeviceBuilder;
import net.jami.jams.ca.workers.csr.builders.SystemAccountBuilder;
import net.jami.jams.ca.workers.csr.builders.UserBuilder;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.system.SystemAccount;
import net.jami.jams.common.objects.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateWorker {
    private static final Logger log = LoggerFactory.getLogger(CertificateWorker.class);
    public static final long SHIFT = 43200000L;

    public static SystemAccount getSignedCertificate(SystemAccount systemAccount) {
        switch (systemAccount.getSystemAccountType()) {
            case CA: {
                return SystemAccountBuilder.generateCA(systemAccount);
            }
            case OCSP: {
                return SystemAccountBuilder.generateOCSP(systemAccount);
            }
        }
        return null;
    }

    public static User getSignedCertificate(User user) {
        return UserBuilder.generateUser(user);
    }

    public static Device getSignedCertificate(User user, Device device) {
        return DeviceBuilder.generateDevice(user, device);
    }
}

