/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.authmodule;

import com.nimbusds.jwt.SignedJWT;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.concurrent.ConcurrentHashMap;
import net.jami.datastore.main.DataStore;
import net.jami.jams.authmodule.PasswordUtil;
import net.jami.jams.authmodule.RegisterUserFlow;
import net.jami.jams.authmodule.TokenController;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.authmodule.AuthTokenResponse;
import net.jami.jams.common.authmodule.AuthenticationModule;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.jami.NameServer;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.utils.LibraryLoader;
import net.jami.jams.common.utils.X509Utils;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthenticationModule
implements AuthenticationModule {
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationModule.class);
    private static final String LDAP_CONNECTOR_CLASS = "net.jami.jams.ldap.connector.LDAPConnector";
    private static final String AD_CONNECTOR_CLASS = "net.jami.jams.ad.connector.ADConnector";
    public static DataStore datastore;
    public static CertificateAuthority certificateAuthority;
    private final TokenController tokenController;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private final ConcurrentHashMap<AuthModuleKey, AuthenticationSource> authenticationSources = new ConcurrentHashMap();

    public UserAuthenticationModule(DataStore dataStore, CertificateAuthority certificateAuthority) throws Exception {
        datastore = dataStore;
        UserAuthenticationModule.certificateAuthority = certificateAuthority;
        this.authenticationSources.put(new AuthModuleKey("LOCAL", AuthenticationSourceType.LOCAL), datastore);
        log.info("Started authentication module - default local source is already enabled!");
        File pubkeyFile = new File(System.getProperty("user.dir") + File.separator + "oauth.pub");
        File privateKeyFile = new File(System.getProperty("user.dir") + File.separator + "oauth.key");
        if (!privateKeyFile.exists() || !pubkeyFile.exists()) {
            log.info("Generating first time private/public keys for OAuth!");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(4096);
            KeyPair kp = keyPairGenerator.generateKeyPair();
            this.privateKey = kp.getPrivate();
            this.publicKey = kp.getPublic();
            FileOutputStream os = new FileOutputStream(System.getProperty("user.dir") + File.separator + "oauth.key");
            ((OutputStream)os).write(X509Utils.getPEMStringFromPrivateKey(this.privateKey).getBytes());
            os.flush();
            ((OutputStream)os).close();
            log.info("Succesfully stored OAuth private key for future use...");
            os = new FileOutputStream(System.getProperty("user.dir") + File.separator + "oauth.pub");
            ((OutputStream)os).write(X509Utils.getPEMStringFromPubKey(this.publicKey).getBytes());
            os.flush();
            ((OutputStream)os).close();
            log.info("Succesfully stored OAuth public key for future use...");
        } else {
            this.privateKey = X509Utils.getKeyFromPEMString(new String(new FileInputStream(privateKeyFile).readAllBytes()));
            log.info("Succesfully loaded OAuth private key!");
            this.publicKey = X509Utils.getPubKeyFromPEMString(new String(new FileInputStream(pubkeyFile).readAllBytes()));
            log.info("Succesfully loaded OAuth public key!");
        }
        this.tokenController = new TokenController(this.privateKey);
        log.info("OAuth2 Token System instantiated succesfully!");
    }

    @Override
    public void attachAuthSource(AuthenticationSourceType type, String settings) {
        switch (type) {
            case AD: {
                this.loadAuthConnector(AD_CONNECTOR_CLASS, settings);
                break;
            }
            case LDAP: {
                this.loadAuthConnector(LDAP_CONNECTOR_CLASS, settings);
                break;
            }
        }
    }

    private void loadAuthConnector(String className, String settings) {
        try {
            Class<?> cls = LibraryLoader.classLoader.loadClass(className);
            AuthenticationSource source = (AuthenticationSource)cls.getConstructor(String.class).newInstance(settings);
            this.authenticationSources.put(new AuthModuleKey(source.getInfo().getRealm(), source.getInfo().getAuthenticationSourceType()), source);
        }
        catch (Exception e) {
            log.error("Could not load connector " + className + " with reason: " + e.toString());
        }
    }

    @Override
    public AuthTokenResponse authenticateUser(String username, String password) {
        User user;
        AuthTokenResponse res = null;
        String hashPass = "";
        if (datastore.userExists(username)) {
            StatementList statementList = new StatementList();
            StatementElement statementElement = new StatementElement("username", "=", username, "");
            statementList.addStatement(statementElement);
            user = (User)datastore.getUserDao().getObjects(statementList).get(0);
            if (user.getUserType() == AuthenticationSourceType.LOCAL) {
                hashPass = PasswordUtil.hashPassword(password, Base64.decodeBase64(user.getSalt()));
            }
            if (hashPass != null && this.authenticationSources.get(new AuthModuleKey(user.getRealm(), user.getUserType())).authenticate(username, hashPass)) {
                return this.tokenController.getToken(user, null);
            }
        }
        for (AuthModuleKey key : this.authenticationSources.keySet()) {
            if (!this.authenticationSources.get(key).authenticate(username, password)) continue;
            user = new User();
            user.setUsername(username);
            user.setAccessLevel(AccessLevel.USER);
            user.setRealm(key.getRealm());
            user.setUserType(key.getType());
            RegisterUserFlow.createUser(user, null);
            return this.tokenController.getToken(user, null);
        }
        return res;
    }

    @Override
    public AuthTokenResponse authenticateUser(X509Certificate[] certificates, X509CRLHolder crl, X509Certificate ca) {
        X509Certificate clientCert = certificates[1];
        X509Certificate deviceCert = certificates[0];
        try {
            clientCert.checkValidity();
            clientCert.verify(ca.getPublicKey());
            if (crl.getRevokedCertificate(clientCert.getSerialNumber()) != null) {
                return null;
            }
            String username = X509Utils.extractDNFromCertificate(clientCert).get("CN");
            StatementList statementList = new StatementList();
            StatementElement statementElement = new StatementElement("username", "=", username, "");
            statementList.addStatement(statementElement);
            User user = (User)datastore.getUserDao().getObjects(statementList).get(0);
            return this.tokenController.getToken(user, X509Utils.extractDNFromCertificate(deviceCert).get("UID"));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ConcurrentHashMap<AuthModuleKey, AuthenticationSource> getAuthSources() {
        return this.authenticationSources;
    }

    @Override
    public boolean testModuleConfiguration(AuthenticationSourceType type, String settings) {
        try {
            String className = "";
            if (type.equals((Object)AuthenticationSourceType.AD)) {
                className = AD_CONNECTOR_CLASS;
            }
            if (type.equals((Object)AuthenticationSourceType.LDAP)) {
                className = LDAP_CONNECTOR_CLASS;
            }
            Class<?> cls = LibraryLoader.classLoader.loadClass(className);
            AuthenticationSource source = (AuthenticationSource)cls.getConstructor(String.class).newInstance(settings);
            return source.test();
        }
        catch (Exception e) {
            log.error("The testing of the source was unsuccessful: " + e.toString());
            return false;
        }
    }

    @Override
    public boolean createUser(AuthenticationSourceType type, String realm, NameServer nameServer, User user) {
        return RegisterUserFlow.createUser(user, nameServer);
    }

    @Override
    public RSAPublicKey getAuthModulePubKey() {
        return (RSAPublicKey)this.publicKey;
    }

    @Override
    public char[] getOTP(String username) {
        if (datastore.userExists(username)) {
            StatementList statementList = new StatementList();
            StatementElement statementElement = new StatementElement("username", "=", username, "");
            statementList.addStatement(statementElement);
            User user = (User)datastore.getUserDao().getObjects(statementList).get(0);
            return user.getPassword().toCharArray();
        }
        return new char[0];
    }

    @Override
    public boolean verifyToken(SignedJWT token) {
        return false;
    }

    @Override
    public void deleteToken(SignedJWT token) {
    }
}

