/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.user.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyDao
extends AbstractDao<Policy> {
    private static final Logger log = LoggerFactory.getLogger(PolicyDao.class);

    public PolicyDao() {
        this.setTableName("policies");
        this.setTClass(Policy.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(Policy object) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("INSERT INTO policies (name, policyData) VALUES (?, ?)");
            ps = object.getInsert(ps);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to store a blueprint: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateObject(StatementList update, StatementList constraints) {
        String name = update.getStatements().get(0).getValue();
        String policyData = update.getStatements().get(1).getValue();
        String oldName = constraints.getStatements().get(0).getValue();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("UPDATE policies SET name = ?, policyData = ? WHERE name = ?");
            ps.setString(1, name);
            ps.setString(2, policyData);
            ps.setString(3, oldName);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to update a blueprint: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteObject(StatementList constraints) {
        String name = constraints.getStatements().get(0).getValue();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("DELETE FROM policies WHERE name = ?");
            ps.setString(1, name);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            log.error("An error has occurred while trying to delete a blueprint: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }
}

