/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.contacts.Contact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDao
extends AbstractDao<Contact> {
    private static final Logger log = LoggerFactory.getLogger(ContactDao.class);

    public ContactDao() {
        this.setTableName("contacts");
        this.setTClass(Contact.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(Contact object) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            String insert = "INSERT INTO contacts (owner, uri, displayName, `timestamp`, status) VALUES (?, ?, ?, ?, ?)";
            PreparedStatement ps = connection.getConnection().prepareStatement(insert);
            object.getInsert(ps);
            ps.executeQuery();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Could not update contacts!");
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeContactList(List<Contact> contactList) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            String delete = "DELETE FROM contacts WHERE owner = ?";
            PreparedStatement ps = connection.getConnection().prepareStatement(delete);
            ps.setString(1, contactList.get(0).getOwner());
            ps.executeUpdate();
            String insert = "INSERT INTO contacts (owner, uri, displayName, timestamp, status,banned,confirmed) VALUES (?, ?, ?, ?, ?,?,?)";
            for (Contact contact : contactList) {
                ps = connection.getConnection().prepareStatement(insert);
                contact.getInsert(ps);
                ps.executeUpdate();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Could not update contacts: {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteObject(StatementList constraints) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("DELETE FROM contacts WHERE owner = ? AND uri = ?");
            ps.setString(1, constraints.getStatements().get(0).getValue());
            ps.setString(2, constraints.getStatements().get(1).getValue());
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            log.error("Could not delete contact: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }
}

