/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import java.util.TimeZone;

public final class UtcOffset {
    private final long millis;

    public UtcOffset(boolean positive, int hour, int minute) {
        int sign = positive ? 1 : -1;
        hour = Math.abs(hour);
        minute = Math.abs(minute);
        this.millis = (long)sign * (UtcOffset.hoursToMillis(hour) + UtcOffset.minutesToMillis(minute));
    }

    public UtcOffset(long millis) {
        this.millis = millis;
    }

    public static UtcOffset parse(String text) {
        int minute;
        int hour;
        String hourStr;
        int i = 0;
        char sign = text.charAt(i);
        boolean positive = true;
        if (sign == '-') {
            positive = false;
            ++i;
        } else if (sign == '+') {
            ++i;
        }
        int maxLength = i + 4;
        int colon = text.indexOf(58, i);
        if (colon >= 0) {
            ++maxLength;
        }
        if (text.length() > maxLength) {
            throw Messages.INSTANCE.getIllegalArgumentException(40, text);
        }
        String minuteStr = null;
        if (colon < 0) {
            hourStr = text.substring(i);
            int minutePos = hourStr.length() - 2;
            if (minutePos > 0) {
                minuteStr = hourStr.substring(minutePos);
                hourStr = hourStr.substring(0, minutePos);
            }
        } else {
            hourStr = text.substring(i, colon);
            if (colon < text.length() - 1) {
                minuteStr = text.substring(colon + 1);
            }
        }
        try {
            hour = Integer.parseInt(hourStr);
            minute = minuteStr == null ? 0 : Integer.parseInt(minuteStr);
        }
        catch (NumberFormatException e) {
            throw Messages.INSTANCE.getIllegalArgumentException(40, text);
        }
        return new UtcOffset(positive, hour, minute);
    }

    public static UtcOffset parse(TimeZone timezone) {
        long offset = timezone.getOffset(System.currentTimeMillis());
        return new UtcOffset(offset);
    }

    public long getMillis() {
        return this.millis;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean extended) {
        StringBuilder sb = new StringBuilder();
        boolean positive = this.millis >= 0L;
        long hour = Math.abs(UtcOffset.millisToHours(this.millis));
        long minute = Math.abs(UtcOffset.millisToMinutes(this.millis));
        sb.append(positive ? (char)'+' : '-');
        if (hour < 10L) {
            sb.append('0');
        }
        sb.append(hour);
        if (extended) {
            sb.append(':');
        }
        if (minute < 10L) {
            sb.append('0');
        }
        sb.append(minute);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.millis ^ this.millis >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UtcOffset other = (UtcOffset)obj;
        return this.millis == other.millis;
    }

    private static long hoursToMillis(long hours) {
        return hours * 60L * 60L * 1000L;
    }

    private static long minutesToMillis(long minutes) {
        return minutes * 60L * 1000L;
    }

    private static long millisToHours(long millis) {
        return millis / 1000L / 60L / 60L;
    }

    private static long millisToMinutes(long millis) {
        return millis / 1000L / 60L % 60L;
    }
}

