/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import ezvcard.util.CharacterBitSet;
import ezvcard.util.ClearableStringBuilder;
import ezvcard.util.StringUtils;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TelUri {
    private static final boolean[] validParameterValueCharacters;
    private static final Pattern hexPattern;
    private static final String PARAM_EXTENSION = "ext";
    private static final String PARAM_ISDN_SUBADDRESS = "isub";
    private static final String PARAM_PHONE_CONTEXT = "phone-context";
    private final String number;
    private final String extension;
    private final String isdnSubaddress;
    private final String phoneContext;
    private final Map<String, String> parameters;

    private TelUri(Builder builder) {
        this.number = builder.number;
        this.extension = builder.extension;
        this.isdnSubaddress = builder.isdnSubaddress;
        this.phoneContext = builder.phoneContext;
        this.parameters = Collections.unmodifiableMap(builder.parameters);
    }

    public static TelUri parse(String uri) {
        String scheme = "tel:";
        if (uri.length() < scheme.length() || !uri.substring(0, scheme.length()).equalsIgnoreCase(scheme)) {
            throw Messages.INSTANCE.getIllegalArgumentException(18, scheme);
        }
        Builder builder = new Builder();
        ClearableStringBuilder buffer = new ClearableStringBuilder();
        String paramName = null;
        for (int i = scheme.length(); i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == '=' && builder.number != null && paramName == null) {
                paramName = buffer.getAndClear();
                continue;
            }
            if (c == ';') {
                TelUri.handleEndOfParameter(buffer, paramName, builder);
                paramName = null;
                continue;
            }
            buffer.append(c);
        }
        TelUri.handleEndOfParameter(buffer, paramName, builder);
        return builder.build();
    }

    private static void addParameter(String name, String value, Builder builder) {
        value = TelUri.decodeParameterValue(value);
        if (PARAM_EXTENSION.equalsIgnoreCase(name)) {
            builder.extension = value;
            return;
        }
        if (PARAM_ISDN_SUBADDRESS.equalsIgnoreCase(name)) {
            builder.isdnSubaddress = value;
            return;
        }
        if (PARAM_PHONE_CONTEXT.equalsIgnoreCase(name)) {
            builder.phoneContext = value;
            return;
        }
        builder.parameters.put(name, value);
    }

    private static void handleEndOfParameter(ClearableStringBuilder buffer, String paramName, Builder builder) {
        String s = buffer.getAndClear();
        if (builder.number == null) {
            builder.number = s;
            return;
        }
        if (paramName == null) {
            if (s.length() > 0) {
                TelUri.addParameter(s, "", builder);
            }
            return;
        }
        TelUri.addParameter(paramName, s, builder);
    }

    public String getNumber() {
        return this.number;
    }

    public String getPhoneContext() {
        return this.phoneContext;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getIsdnSubaddress() {
        return this.isdnSubaddress;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("tel:");
        sb.append(this.number);
        if (this.extension != null) {
            TelUri.writeParameter(PARAM_EXTENSION, this.extension, sb);
        }
        if (this.isdnSubaddress != null) {
            TelUri.writeParameter(PARAM_ISDN_SUBADDRESS, this.isdnSubaddress, sb);
        }
        if (this.phoneContext != null) {
            TelUri.writeParameter(PARAM_PHONE_CONTEXT, this.phoneContext, sb);
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            TelUri.writeParameter(name, value, sb);
        }
        return sb.toString();
    }

    private static void writeParameter(String name, String value, StringBuilder sb) {
        sb.append(';').append(name).append('=').append(TelUri.encodeParameterValue(value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extension == null ? 0 : this.extension.toLowerCase().hashCode());
        result = 31 * result + (this.isdnSubaddress == null ? 0 : this.isdnSubaddress.toLowerCase().hashCode());
        result = 31 * result + (this.number == null ? 0 : this.number.toLowerCase().hashCode());
        result = 31 * result + (this.parameters == null ? 0 : StringUtils.toLowerCase(this.parameters).hashCode());
        result = 31 * result + (this.phoneContext == null ? 0 : this.phoneContext.toLowerCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TelUri other = (TelUri)obj;
        if (this.extension == null ? other.extension != null : !this.extension.equalsIgnoreCase(other.extension)) {
            return false;
        }
        if (this.isdnSubaddress == null ? other.isdnSubaddress != null : !this.isdnSubaddress.equalsIgnoreCase(other.isdnSubaddress)) {
            return false;
        }
        if (this.number == null ? other.number != null : !this.number.equalsIgnoreCase(other.number)) {
            return false;
        }
        if (this.parameters == null) {
            if (other.parameters != null) {
                return false;
            }
        } else {
            Map<String, String> otherParametersLower;
            if (other.parameters == null) {
                return false;
            }
            if (this.parameters.size() != other.parameters.size()) {
                return false;
            }
            Map<String, String> parametersLower = StringUtils.toLowerCase(this.parameters);
            if (!parametersLower.equals(otherParametersLower = StringUtils.toLowerCase(other.parameters))) {
                return false;
            }
        }
        return !(this.phoneContext == null ? other.phoneContext != null : !this.phoneContext.equalsIgnoreCase(other.phoneContext));
    }

    private static String encodeParameterValue(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < validParameterValueCharacters.length && validParameterValueCharacters[c]) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(value.length() * 2);
                sb.append(value.substring(0, i));
            }
            String hex = Integer.toString(c, 16);
            sb.append('%').append(hex);
        }
        return sb == null ? value : sb.toString();
    }

    private static String decodeParameterValue(String value) {
        Matcher m = hexPattern.matcher(value);
        StringBuffer sb = null;
        while (m.find()) {
            if (sb == null) {
                sb = new StringBuffer(value.length());
            }
            int hex = Integer.parseInt(m.group(1), 16);
            m.appendReplacement(sb, Character.toString((char)hex));
        }
        if (sb == null) {
            return value;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static {
        int i;
        validParameterValueCharacters = new boolean[128];
        for (i = 48; i <= 57; ++i) {
            TelUri.validParameterValueCharacters[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            TelUri.validParameterValueCharacters[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            TelUri.validParameterValueCharacters[i] = true;
        }
        String s = "!$&'()*+-.:[]_~/";
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            TelUri.validParameterValueCharacters[c] = true;
        }
        hexPattern = Pattern.compile("(?i)%([0-9a-f]{2})");
    }

    public static class Builder {
        private String number;
        private String extension;
        private String isdnSubaddress;
        private String phoneContext;
        private Map<String, String> parameters;
        private CharacterBitSet validParamNameChars = new CharacterBitSet("a-zA-Z0-9-");

        private Builder() {
            this.parameters = new TreeMap<String, String>();
        }

        public Builder(String globalNumber) {
            this();
            this.globalNumber(globalNumber);
        }

        public Builder(String localNumber, String phoneContext) {
            this();
            this.localNumber(localNumber, phoneContext);
        }

        public Builder(TelUri original) {
            this.number = original.number;
            this.extension = original.extension;
            this.isdnSubaddress = original.isdnSubaddress;
            this.phoneContext = original.phoneContext;
            this.parameters = new TreeMap<String, String>(original.parameters);
        }

        public Builder globalNumber(String globalNumber) {
            if (!globalNumber.startsWith("+")) {
                throw Messages.INSTANCE.getIllegalArgumentException(26, new Object[0]);
            }
            CharacterBitSet validChars = new CharacterBitSet("0-9.()-");
            if (!validChars.containsOnly(globalNumber, 1)) {
                throw Messages.INSTANCE.getIllegalArgumentException(27, new Object[0]);
            }
            CharacterBitSet requiredChars = new CharacterBitSet("0-9");
            if (!requiredChars.containsAny(globalNumber, 1)) {
                throw Messages.INSTANCE.getIllegalArgumentException(25, new Object[0]);
            }
            this.number = globalNumber;
            this.phoneContext = null;
            return this;
        }

        public Builder localNumber(String localNumber, String phoneContext) {
            CharacterBitSet validChars = new CharacterBitSet("0-9.()*#-");
            if (!validChars.containsOnly(localNumber)) {
                throw Messages.INSTANCE.getIllegalArgumentException(28, new Object[0]);
            }
            CharacterBitSet requiredChars = new CharacterBitSet("0-9*#");
            if (!requiredChars.containsAny(localNumber)) {
                throw Messages.INSTANCE.getIllegalArgumentException(28, new Object[0]);
            }
            this.number = localNumber;
            this.phoneContext = phoneContext;
            return this;
        }

        public Builder extension(String extension) {
            CharacterBitSet validChars;
            if (extension != null && !(validChars = new CharacterBitSet("0-9.()-")).containsOnly(extension)) {
                throw Messages.INSTANCE.getIllegalArgumentException(29, new Object[0]);
            }
            this.extension = extension;
            return this;
        }

        public Builder isdnSubaddress(String isdnSubaddress) {
            this.isdnSubaddress = isdnSubaddress;
            return this;
        }

        public Builder parameter(String name, String value) {
            if (!this.validParamNameChars.containsOnly(name)) {
                throw Messages.INSTANCE.getIllegalArgumentException(23, new Object[0]);
            }
            if (value == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, value);
            }
            return this;
        }

        public TelUri build() {
            return new TelUri(this);
        }
    }
}

