/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.SupportedVersions;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.ValidationWarnings;
import ezvcard.property.VCardProperty;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedVersions(value={VCardVersion.V2_1, VCardVersion.V3_0})
public class Agent
extends VCardProperty {
    private String url;
    private VCard vcard;

    public Agent() {
    }

    public Agent(String url) {
        this.setUrl(url);
    }

    public Agent(VCard vcard) {
        this.setVCard(vcard);
    }

    public Agent(Agent original) {
        super(original);
        this.url = original.url;
        this.vcard = original.vcard == null ? null : new VCard(original.vcard);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.vcard = null;
    }

    public VCard getVCard() {
        return this.vcard;
    }

    public void setVCard(VCard vcard) {
        this.vcard = vcard;
        this.url = null;
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.url == null && this.vcard == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
        if (this.vcard != null) {
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(2);
            ValidationWarnings validationWarnings = this.vcard.validate(version);
            for (Map.Entry<VCardProperty, List<ValidationWarning>> entry : validationWarnings) {
                VCardProperty property = entry.getKey();
                List<ValidationWarning> propViolations = entry.getValue();
                for (ValidationWarning propViolation : propViolations) {
                    String className = property == null ? "" : property.getClass().getSimpleName();
                    int code = propViolation.getCode();
                    String codeStr = code >= 0 ? "W" + nf.format(code) : "";
                    String message = propViolation.getMessage();
                    warnings.add(new ValidationWarning(10, className, codeStr, message));
                }
            }
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("url", this.url);
        values.put("vcard", this.vcard);
        return values;
    }

    @Override
    public Agent copy() {
        return new Agent(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.vcard == null ? 0 : this.vcard.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Agent other = (Agent)obj;
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.vcard == null ? other.vcard != null : !this.vcard.equals(other.vcard));
    }
}

