/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.parameter;

public class Pid {
    private final Integer localId;
    private final Integer clientPidMapReference;

    public Pid(Integer localId, Integer clientPidMapReference) {
        if (localId == null) {
            throw new NullPointerException("Local ID must not be null.");
        }
        this.localId = localId;
        this.clientPidMapReference = clientPidMapReference;
    }

    public Pid(Integer localId) {
        this(localId, null);
    }

    public Integer getLocalId() {
        return this.localId;
    }

    public Integer getClientPidMapReference() {
        return this.clientPidMapReference;
    }

    public static Pid valueOf(String value) {
        String clientPidMapReferenceStr;
        String localIdStr;
        int dot = value.indexOf(46);
        if (dot < 0) {
            localIdStr = value;
            clientPidMapReferenceStr = null;
        } else {
            localIdStr = value.substring(0, dot);
            clientPidMapReferenceStr = dot == value.length() - 1 ? null : value.substring(dot + 1);
        }
        Integer localId = Integer.valueOf(localIdStr);
        Integer clientPidMapReference = clientPidMapReferenceStr == null ? null : Integer.valueOf(clientPidMapReferenceStr);
        return new Pid(localId, clientPidMapReference);
    }

    public String toString() {
        return this.clientPidMapReference == null ? Integer.toString(this.localId) : this.localId + "." + this.clientPidMapReference;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientPidMapReference == null ? 0 : this.clientPidMapReference.hashCode());
        result = 31 * result + this.localId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pid other = (Pid)obj;
        if (this.clientPidMapReference == null ? other.clientPidMapReference != null : !this.clientPidMapReference.equals(other.clientPidMapReference)) {
            return false;
        }
        return this.localId.equals(other.localId);
    }
}

