/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.chain;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.io.chain.ChainingWriter;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardDocument;
import ezvcard.io.xml.XCardOutputProperties;
import ezvcard.property.VCardProperty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingXmlWriter
extends ChainingWriter<ChainingXmlWriter> {
    private final XCardOutputProperties outputProperties = new XCardOutputProperties();
    private final Map<String, VCardDataType> parameterDataTypes = new HashMap<String, VCardDataType>(0);

    public ChainingXmlWriter(Collection<VCard> vcards) {
        super(vcards);
    }

    public ChainingXmlWriter indent(Integer indent) {
        this.outputProperties.setIndent(indent);
        return this;
    }

    public ChainingXmlWriter xmlVersion(String xmlVersion) {
        this.outputProperties.setXmlVersion(xmlVersion);
        return this;
    }

    public ChainingXmlWriter outputProperty(String name, String value) {
        this.outputProperties.put(name, value);
        return this;
    }

    public ChainingXmlWriter outputProperties(Map<String, String> outputProperties) {
        this.outputProperties.putAll(outputProperties);
        return this;
    }

    @Override
    public ChainingXmlWriter prodId(boolean include) {
        return (ChainingXmlWriter)super.prodId(include);
    }

    @Override
    public ChainingXmlWriter versionStrict(boolean versionStrict) {
        return (ChainingXmlWriter)super.versionStrict(versionStrict);
    }

    @Override
    public ChainingXmlWriter register(VCardPropertyScribe<? extends VCardProperty> scribe) {
        return (ChainingXmlWriter)super.register(scribe);
    }

    public ChainingXmlWriter register(String parameterName, VCardDataType dataType) {
        this.parameterDataTypes.put(parameterName, dataType);
        return this;
    }

    public String go() {
        return this.createXCardDocument().write(this.outputProperties);
    }

    public void go(OutputStream out) throws TransformerException {
        this.createXCardDocument().write(out, (Map<String, String>)this.outputProperties);
    }

    public void go(File file) throws IOException, TransformerException {
        this.createXCardDocument().write(file, (Map<String, String>)this.outputProperties);
    }

    public void go(Writer writer) throws TransformerException {
        this.createXCardDocument().write(writer, (Map<String, String>)this.outputProperties);
    }

    public Document dom() {
        return this.createXCardDocument().getDocument();
    }

    private XCardDocument createXCardDocument() {
        XCardDocument document = new XCardDocument();
        XCardDocument.XCardDocumentStreamWriter writer = document.writer();
        writer.setAddProdId(this.prodId);
        writer.setVersionStrict(this.versionStrict);
        for (Map.Entry<String, VCardDataType> entry : this.parameterDataTypes.entrySet()) {
            String parameterName = entry.getKey();
            VCardDataType dataType = entry.getValue();
            writer.registerParameterDataType(parameterName, dataType);
        }
        if (this.index != null) {
            writer.setScribeIndex(this.index);
        }
        for (VCard vcard : this.vcards) {
            writer.write(vcard);
        }
        return document;
    }
}

