/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.StringLiteral;
import org.mapstruct.ap.shaded.freemarker.core._DelayedGetMessage;
import org.mapstruct.ap.shaded.freemarker.core._DelayedJQuote;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.template.SimpleSequence;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateSequenceModel;

final class ListLiteral
extends Expression {
    final ArrayList items;

    ListLiteral(ArrayList items) {
        this.items = items;
        items.trimToSize();
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        SimpleSequence list = new SimpleSequence(this.items.size());
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            Expression exp = (Expression)it.next();
            TemplateModel tm = exp.eval(env);
            if (env == null || !env.isClassicCompatible()) {
                exp.assertNonNull(tm, env);
            }
            list.add(tm);
        }
        return list;
    }

    List getValueList(Environment env) throws TemplateException {
        int size = this.items.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(((Expression)this.items.get(0)).evalAndCoerceToString(env));
            }
        }
        ArrayList<String> result = new ArrayList<String>(this.items.size());
        ListIterator iterator = this.items.listIterator();
        while (iterator.hasNext()) {
            Expression exp = (Expression)iterator.next();
            result.add(exp.evalAndCoerceToString(env));
        }
        return result;
    }

    List getModelList(Environment env) throws TemplateException {
        int size = this.items.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(((Expression)this.items.get(0)).eval(env));
            }
        }
        ArrayList<TemplateModel> result = new ArrayList<TemplateModel>(this.items.size());
        ListIterator iterator = this.items.listIterator();
        while (iterator.hasNext()) {
            Expression exp = (Expression)iterator.next();
            result.add(exp.eval(env));
        }
        return result;
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("[");
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            Expression value = (Expression)this.items.get(i);
            buf.append(value.getCanonicalForm());
            if (i == size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "[...]";
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            Expression exp = (Expression)this.items.get(i);
            if (exp.isLiteral()) continue;
            return false;
        }
        return true;
    }

    TemplateSequenceModel evaluateStringsToNamespaces(Environment env) throws TemplateException {
        TemplateSequenceModel val2 = (TemplateSequenceModel)this.eval(env);
        SimpleSequence result = new SimpleSequence(val2.size());
        for (int i = 0; i < this.items.size(); ++i) {
            Object itemExpr = this.items.get(i);
            if (itemExpr instanceof StringLiteral) {
                String s = ((StringLiteral)itemExpr).getAsString();
                try {
                    Environment.Namespace ns = env.importLib(s, null);
                    result.add(ns);
                    continue;
                }
                catch (IOException ioe) {
                    throw new _MiscTemplateException((Expression)((StringLiteral)itemExpr), new Object[]{"Couldn't import library ", new _DelayedJQuote(s), ": ", new _DelayedGetMessage(ioe)});
                }
            }
            result.add(val2.get(i));
        }
        return result;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        ArrayList clonedValues = (ArrayList)this.items.clone();
        ListIterator<Expression> iter = clonedValues.listIterator();
        while (iter.hasNext()) {
            iter.set(((Expression)iter.next()).deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
        }
        return new ListLiteral(clonedValues);
    }

    int getParameterCount() {
        return this.items != null ? this.items.size() : 0;
    }

    Object getParameterValue(int idx) {
        this.checkIndex(idx);
        return this.items.get(idx);
    }

    ParameterRole getParameterRole(int idx) {
        this.checkIndex(idx);
        return ParameterRole.ITEM_VALUE;
    }

    private void checkIndex(int idx) {
        if (this.items == null || idx >= this.items.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

