/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca.workers.crl;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.ca.workers.X509Worker;
import net.jami.jams.ca.workers.crl.CRLFileStorage;
import net.jami.jams.common.objects.requests.RevocationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLWorker
extends X509Worker<RevocationRequest> {
    private static final Logger log = LoggerFactory.getLogger(CRLWorker.class);
    private final AtomicReference<X509CRLHolder> existingCRL = new AtomicReference();
    private final CRLFileStorage crlFileStorage = new CRLFileStorage(System.getProperty("user.dir") + File.separator + "crl.pem");
    private AtomicBoolean stop = new AtomicBoolean(false);

    public CRLWorker(PrivateKey privateKey, X509Certificate certificate) {
        super(privateKey, certificate);
        try {
            this.existingCRL.set((X509CRLHolder)this.crlFileStorage.getData());
        }
        catch (Exception e) {
            log.warn("Could not find existing CRL file, if this is the first time you are starting the server or no CRL existed, this is fine");
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(new X500Name(this.getCertificate().getSubjectDN().getName()), new Date());
            try {
                this.existingCRL.set(crlBuilder.build(new JcaContentSignerBuilder("SHA512WITHRSA").setProvider("BC").build(this.getSigningKey())));
                this.crlFileStorage.storeData(this.existingCRL.get());
            }
            catch (Exception e1) {
                log.error("Could not create blank CRL!");
            }
        }
        this.setDaemon(true);
        this.start();
        log.info("Instantiated & started a CRL Worker...");
    }

    private void revokeCertificate(RevocationRequest revocationRequest) {
        try {
            X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(new X500Name(this.getCertificate().getSubjectDN().getName()), new Date());
            if (revocationRequest != null) {
                crlBuilder.addCRLEntry(revocationRequest.getIdentifier(), new Date(), 9);
            }
            crlBuilder.addCRL(this.existingCRL.get());
            this.existingCRL.set(crlBuilder.build(new JcaContentSignerBuilder("SHA512WITHRSA").setProvider("BC").build(this.getSigningKey())));
            boolean failedWrite = true;
            while (failedWrite) {
                try {
                    this.crlFileStorage.storeData(this.existingCRL.get());
                    failedWrite = false;
                }
                catch (Exception e) {
                    log.warn("Failed to write file, trying again!");
                }
            }
            log.info("Successfully ran revocation routine");
        }
        catch (Exception e) {
            log.error("Failed to sign a CRL with error " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean needsRefresh = false;
        while (!this.stop.get()) {
            try {
                while (this.getInput().isEmpty()) {
                    if (needsRefresh) {
                        this.revokeCertificate(null);
                        needsRefresh = false;
                    }
                    ConcurrentLinkedQueue concurrentLinkedQueue = this.getInput();
                    synchronized (concurrentLinkedQueue) {
                        this.getInput().wait(JamsCA.crlLifetime - 10000L);
                        needsRefresh = true;
                    }
                }
                while (!this.getInput().isEmpty()) {
                    RevocationRequest revocationRequest = (RevocationRequest)this.getInput().poll();
                    this.revokeCertificate(revocationRequest);
                    needsRefresh = false;
                    log.info("Successfully revoked the certificated with ID " + revocationRequest.getIdentifier());
                }
            }
            catch (Exception e) {
                log.error("An error has occured in the CRL signing thread: " + e.toString());
            }
        }
        log.info("Stopped CRL Worker Thread...");
    }

    public AtomicReference<X509CRLHolder> getExistingCRL() {
        return this.existingCRL;
    }

    public CRLFileStorage getCrlFileStorage() {
        return this.crlFileStorage;
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }

    public void setStop(AtomicBoolean stop) {
        this.stop = stop;
    }
}

