/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.Codegen;
import com.jsoniter.output.CodegenAccess;
import com.jsoniter.output.CodegenResult;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

class CodegenImplNative {
    public static final Map<Type, Encoder.ReflectionEncoder> NATIVE_ENCODERS = new IdentityHashMap<Type, Encoder.ReflectionEncoder>(){
        {
            this.put(Boolean.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Boolean)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Boolean val2 = (Boolean)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Boolean.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Boolean)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Boolean val2 = (Boolean)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Byte.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal(((Byte)obj).shortValue());
                }

                @Override
                public Any wrap(Object obj) {
                    Byte val2 = (Byte)obj;
                    return Any.wrap(val2.byteValue());
                }
            });
            this.put(Byte.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal(((Byte)obj).shortValue());
                }

                @Override
                public Any wrap(Object obj) {
                    Byte val2 = (Byte)obj;
                    return Any.wrap(val2.byteValue());
                }
            });
            this.put(Short.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Short)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Short val2 = (Short)obj;
                    return Any.wrap(val2.shortValue());
                }
            });
            this.put(Short.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Short)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Short val2 = (Short)obj;
                    return Any.wrap(val2.shortValue());
                }
            });
            this.put(Integer.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Integer)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Integer val2 = (Integer)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Integer.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Integer)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Integer val2 = (Integer)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Character.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal(((Character)obj).charValue());
                }

                @Override
                public Any wrap(Object obj) {
                    Character val2 = (Character)obj;
                    return Any.wrap(val2.charValue());
                }
            });
            this.put(Character.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal(((Character)obj).charValue());
                }

                @Override
                public Any wrap(Object obj) {
                    Character val2 = (Character)obj;
                    return Any.wrap(val2.charValue());
                }
            });
            this.put(Long.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Long)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Long val2 = (Long)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Long.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Long)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Long val2 = (Long)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Float.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Float)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Float val2 = (Float)obj;
                    return Any.wrap(val2.floatValue());
                }
            });
            this.put(Float.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Float)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Float val2 = (Float)obj;
                    return Any.wrap(val2.floatValue());
                }
            });
            this.put(Double.TYPE, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Double)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Double val2 = (Double)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Double.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((Double)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    Double val2 = (Double)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(String.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    stream.writeVal((String)obj);
                }

                @Override
                public Any wrap(Object obj) {
                    String val2 = (String)obj;
                    return Any.wrap(val2);
                }
            });
            this.put(Object.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    if (obj != null && obj.getClass() == Object.class) {
                        stream.writeEmptyObject();
                        return;
                    }
                    stream.writeVal(obj);
                }

                @Override
                public Any wrap(Object obj) {
                    if (obj != null && obj.getClass() == Object.class) {
                        return Any.rewrap(new HashMap<String, Any>());
                    }
                    return CodegenAccess.wrap(obj);
                }
            });
            this.put(BigDecimal.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    BigDecimal val2 = (BigDecimal)obj;
                    stream.writeRaw(val2.toString());
                }

                @Override
                public Any wrap(Object obj) {
                    return Any.wrap(obj.toString());
                }
            });
            this.put(BigInteger.class, new Encoder.ReflectionEncoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    BigInteger val2 = (BigInteger)obj;
                    stream.writeRaw(val2.toString());
                }

                @Override
                public Any wrap(Object obj) {
                    return Any.wrap(obj.toString());
                }
            });
        }
    };

    CodegenImplNative() {
    }

    public static void genWriteOp(CodegenResult ctx, String code, Type valueType, boolean isNullable) {
        CodegenImplNative.genWriteOp(ctx, code, valueType, isNullable, true);
    }

    public static void genWriteOp(CodegenResult ctx, String code, Type valueType, boolean isNullable, boolean isCollectionValueNullable) {
        boolean noIndention = JsoniterSpi.getCurrentConfig().indentionStep() == 0;
        String cacheKey = TypeLiteral.create(valueType).getEncoderCacheKey();
        if (JsoniterSpi.getEncoder(cacheKey) == null) {
            if (noIndention && !isNullable && String.class == valueType) {
                ctx.buffer('\"');
                ctx.append(String.format("com.jsoniter.output.CodegenAccess.writeStringWithoutQuote((java.lang.String)%s, stream);", code));
                ctx.buffer('\"');
                return;
            }
            if (NATIVE_ENCODERS.containsKey(valueType)) {
                ctx.append(String.format("stream.writeVal((%s)%s);", CodegenImplNative.getTypeName(valueType), code));
                return;
            }
            if (valueType instanceof WildcardType) {
                ctx.append(String.format("stream.writeVal((%s)%s);", CodegenImplNative.getTypeName(Object.class), code));
                return;
            }
        }
        if (!isCollectionValueNullable) {
            cacheKey = cacheKey + "__value_not_nullable";
        }
        Codegen.getEncoder(cacheKey, valueType);
        CodegenResult generatedSource = Codegen.getGeneratedSource(cacheKey);
        if (generatedSource != null) {
            if (isNullable) {
                ctx.appendBuffer();
                ctx.append(CodegenResult.bufferToWriteOp(generatedSource.prelude));
                ctx.append(String.format("%s.encode_((%s)%s, stream);", cacheKey, CodegenImplNative.getTypeName(valueType), code));
                ctx.append(CodegenResult.bufferToWriteOp(generatedSource.epilogue));
            } else {
                ctx.buffer(generatedSource.prelude);
                ctx.append(String.format("%s.encode_((%s)%s, stream);", cacheKey, CodegenImplNative.getTypeName(valueType), code));
                ctx.buffer(generatedSource.epilogue);
            }
        } else {
            ctx.append(String.format("com.jsoniter.output.CodegenAccess.writeVal(\"%s\", (%s)%s, stream);", cacheKey, CodegenImplNative.getTypeName(valueType), code));
        }
    }

    public static String getTypeName(Type fieldType) {
        if (fieldType instanceof Class) {
            Class clazz = (Class)fieldType;
            return clazz.getCanonicalName();
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)fieldType;
            Class clazz = (Class)pType.getRawType();
            return clazz.getCanonicalName();
        }
        if (fieldType instanceof WildcardType) {
            return Object.class.getCanonicalName();
        }
        throw new JsonException("unsupported type: " + fieldType);
    }

    public static CodegenResult genEnum(Class clazz) {
        boolean noIndention = JsoniterSpi.getCurrentConfig().indentionStep() == 0;
        CodegenResult ctx = new CodegenResult();
        ctx.append(String.format("public static void encode_(java.lang.Object obj, com.jsoniter.output.JsonStream stream) throws java.io.IOException {", clazz.getCanonicalName()));
        ctx.append("if (obj == null) { stream.writeNull(); return; }");
        if (noIndention) {
            ctx.buffer('\"');
        } else {
            ctx.append("stream.write('\"');");
        }
        ctx.append("stream.writeRaw(obj.toString());");
        if (noIndention) {
            ctx.buffer('\"');
        } else {
            ctx.append("stream.write('\"');");
        }
        ctx.append("}");
        return ctx;
    }
}

