/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.IterImpl;
import com.jsoniter.JsonIterator;
import java.io.IOException;

class IterImplSkip {
    static final boolean[] breaks = new boolean[127];

    IterImplSkip() {
    }

    public static final void skip(JsonIterator iter) throws IOException {
        byte c = IterImpl.nextToken(iter);
        switch (c) {
            case 34: {
                IterImpl.skipString(iter);
                return;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                IterImpl.skipUntilBreak(iter);
                return;
            }
            case 110: 
            case 116: {
                IterImpl.skipFixedBytes(iter, 3);
                return;
            }
            case 102: {
                IterImpl.skipFixedBytes(iter, 4);
                return;
            }
            case 91: {
                IterImpl.skipArray(iter);
                return;
            }
            case 123: {
                IterImpl.skipObject(iter);
                return;
            }
        }
        throw iter.reportError("IterImplSkip", "do not know how to skip: " + c);
    }

    static final int findStringEnd(JsonIterator iter) {
        boolean escaped = false;
        block0: for (int i = iter.head; i < iter.tail; ++i) {
            byte c = iter.buf[i];
            if (c == 34) {
                if (!escaped) {
                    return i + 1;
                }
                int j = i - 1;
                while (true) {
                    if (j < iter.head || iter.buf[j] != 92) {
                        return i + 1;
                    }
                    if (--j < iter.head || iter.buf[j] != 92) continue block0;
                    --j;
                }
            }
            if (c != 92) continue;
            escaped = true;
        }
        return -1;
    }

    static {
        IterImplSkip.breaks[32] = true;
        IterImplSkip.breaks[9] = true;
        IterImplSkip.breaks[10] = true;
        IterImplSkip.breaks[13] = true;
        IterImplSkip.breaks[44] = true;
        IterImplSkip.breaks[125] = true;
        IterImplSkip.breaks[93] = true;
    }
}

