/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeKind;

public class NativeTypes {
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPES;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPES;
    private static final Set<Class<?>> NUMBER_TYPES;
    private static final Map<TypeKind, String> TYPE_KIND_NAME;
    private static final Map<String, LiteralAnalyzer> ANALYZERS;
    private static final Map<String, Integer> NARROWING_LUT;
    private static final Pattern PTRN_HEX;
    private static final Pattern PTRN_OCT;
    private static final Pattern PTRN_BIN;
    private static final Pattern PTRN_FLOAT_DEC_ZERO;
    private static final Pattern PTRN_FLOAT_HEX_ZERO;
    private static final Pattern PTRN_SIGN;
    private static final Pattern PTRN_LONG;
    private static final Pattern PTRN_FLOAT;
    private static final Pattern PTRN_DOUBLE;
    private static final Pattern PTRN_FAULTY_UNDERSCORE_INT;
    private static final Pattern PTRN_FAULTY_UNDERSCORE_FLOAT;
    private static final Pattern PTRN_FAULTY_DEC_UNDERSCORE_FLOAT;
    private static final Pattern PTRN_FAULTY_HEX_UNDERSCORE_FLOAT;

    private NativeTypes() {
    }

    public static Class<?> getWrapperType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " is no primitive type.");
        }
        return PRIMITIVE_TO_WRAPPER_TYPES.get(clazz);
    }

    public static Class<?> getPrimitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " is no wrapper type.");
        }
        return WRAPPER_TO_PRIMITIVE_TYPES.get(clazz);
    }

    public static boolean isNative(String fullyQualifiedName) {
        return ANALYZERS.containsKey(fullyQualifiedName);
    }

    public static boolean isNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return NUMBER_TYPES.contains(clazz);
    }

    public static Class<?> getLiteral(String className, String literal) {
        LiteralAnalyzer analyzer = ANALYZERS.get(className);
        Class<?> result = null;
        if (analyzer != null) {
            analyzer.validate(literal);
            result = analyzer.getLiteral();
        }
        return result;
    }

    public static String getName(TypeKind typeKind) {
        return TYPE_KIND_NAME.get((Object)typeKind);
    }

    public static boolean isNarrowing(String sourceFQN, String targetFQN) {
        boolean isNarrowing = false;
        Integer sourcePosition = NARROWING_LUT.get(sourceFQN);
        Integer targetPosition = NARROWING_LUT.get(targetFQN);
        if (sourcePosition != null && targetPosition != null) {
            isNarrowing = targetPosition - sourcePosition < 0;
        }
        return isNarrowing;
    }

    static {
        NUMBER_TYPES = new HashSet();
        TYPE_KIND_NAME = new EnumMap<TypeKind, String>(TypeKind.class);
        PTRN_HEX = Pattern.compile("^0[x|X].*");
        PTRN_OCT = Pattern.compile("^0_*[0-7].*");
        PTRN_BIN = Pattern.compile("^0[b|B].*");
        PTRN_FLOAT_DEC_ZERO = Pattern.compile("^[^eE]*[1-9].*[eE]?.*");
        PTRN_FLOAT_HEX_ZERO = Pattern.compile("^[^pP]*[1-9a-fA-F].*[pP]?.*");
        PTRN_SIGN = Pattern.compile("^[\\+|-]");
        PTRN_LONG = Pattern.compile("[l|L]$");
        PTRN_FLOAT = Pattern.compile("[f|F]$");
        PTRN_DOUBLE = Pattern.compile("[d|D]$");
        PTRN_FAULTY_UNDERSCORE_INT = Pattern.compile("^_|_$|-_|_-|\\+_|_\\+");
        PTRN_FAULTY_UNDERSCORE_FLOAT = Pattern.compile("^_|_$|-_|_-|\\+_|_\\+|\\._|_\\.");
        PTRN_FAULTY_DEC_UNDERSCORE_FLOAT = Pattern.compile("_e|_E|e_|E_");
        PTRN_FAULTY_HEX_UNDERSCORE_FLOAT = Pattern.compile("_p|_P|p_|P_");
        HashMap<Class<Serializable>, Class<Serializable>> tmp = new HashMap<Class<Serializable>, Class<Serializable>>();
        tmp.put(Byte.class, Byte.TYPE);
        tmp.put(Short.class, Short.TYPE);
        tmp.put(Integer.class, Integer.TYPE);
        tmp.put(Long.class, Long.TYPE);
        tmp.put(Float.class, Float.TYPE);
        tmp.put(Double.class, Double.TYPE);
        tmp.put(Boolean.class, Boolean.TYPE);
        tmp.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE_TYPES = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put(Byte.TYPE, Byte.class);
        tmp.put(Short.TYPE, Short.class);
        tmp.put(Integer.TYPE, Integer.class);
        tmp.put(Long.TYPE, Long.class);
        tmp.put(Float.TYPE, Float.class);
        tmp.put(Double.TYPE, Double.class);
        tmp.put(Boolean.TYPE, Boolean.class);
        tmp.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER_TYPES = Collections.unmodifiableMap(tmp);
        NUMBER_TYPES.add(Byte.TYPE);
        NUMBER_TYPES.add(Short.TYPE);
        NUMBER_TYPES.add(Integer.TYPE);
        NUMBER_TYPES.add(Long.TYPE);
        NUMBER_TYPES.add(Float.TYPE);
        NUMBER_TYPES.add(Double.TYPE);
        NUMBER_TYPES.add(Byte.class);
        NUMBER_TYPES.add(Short.class);
        NUMBER_TYPES.add(Integer.class);
        NUMBER_TYPES.add(Long.class);
        NUMBER_TYPES.add(Float.class);
        NUMBER_TYPES.add(Double.class);
        NUMBER_TYPES.add(BigInteger.class);
        NUMBER_TYPES.add(BigDecimal.class);
        HashMap<String, LiteralAnalyzer> tmp2 = new HashMap<String, LiteralAnalyzer>();
        tmp2.put(Boolean.TYPE.getCanonicalName(), new BooleanAnalyzer());
        tmp2.put(Boolean.class.getCanonicalName(), new BooleanAnalyzer());
        tmp2.put(Character.TYPE.getCanonicalName(), new CharAnalyzer());
        tmp2.put(Character.class.getCanonicalName(), new CharAnalyzer());
        tmp2.put(Byte.TYPE.getCanonicalName(), new ByteAnalyzer());
        tmp2.put(Byte.class.getCanonicalName(), new ByteAnalyzer());
        tmp2.put(Double.TYPE.getCanonicalName(), new DoubleAnalyzer());
        tmp2.put(Double.class.getCanonicalName(), new DoubleAnalyzer());
        tmp2.put(Float.TYPE.getCanonicalName(), new FloatAnalyzer());
        tmp2.put(Float.class.getCanonicalName(), new FloatAnalyzer());
        tmp2.put(Integer.TYPE.getCanonicalName(), new IntAnalyzer());
        tmp2.put(Integer.class.getCanonicalName(), new IntAnalyzer());
        tmp2.put(Long.TYPE.getCanonicalName(), new LongAnalyzer());
        tmp2.put(Long.class.getCanonicalName(), new LongAnalyzer());
        tmp2.put(Short.TYPE.getCanonicalName(), new ShortAnalyzer());
        tmp2.put(Short.class.getCanonicalName(), new ShortAnalyzer());
        ANALYZERS = Collections.unmodifiableMap(tmp2);
        TYPE_KIND_NAME.put(TypeKind.BOOLEAN, "boolean");
        TYPE_KIND_NAME.put(TypeKind.BYTE, "byte");
        TYPE_KIND_NAME.put(TypeKind.SHORT, "short");
        TYPE_KIND_NAME.put(TypeKind.INT, "int");
        TYPE_KIND_NAME.put(TypeKind.LONG, "long");
        TYPE_KIND_NAME.put(TypeKind.CHAR, "char");
        TYPE_KIND_NAME.put(TypeKind.FLOAT, "float");
        TYPE_KIND_NAME.put(TypeKind.DOUBLE, "double");
        HashMap<String, Integer> tmp3 = new HashMap<String, Integer>();
        tmp3.put(Byte.TYPE.getName(), 1);
        tmp3.put(Byte.class.getName(), 1);
        tmp3.put(Short.TYPE.getName(), 2);
        tmp3.put(Short.class.getName(), 2);
        tmp3.put(Integer.TYPE.getName(), 3);
        tmp3.put(Integer.class.getName(), 3);
        tmp3.put(Long.TYPE.getName(), 4);
        tmp3.put(Long.class.getName(), 4);
        tmp3.put(Float.TYPE.getName(), 5);
        tmp3.put(Float.class.getName(), 5);
        tmp3.put(Double.TYPE.getName(), 6);
        tmp3.put(Double.class.getName(), 6);
        tmp3.put(BigInteger.class.getName(), 50);
        tmp3.put(BigDecimal.class.getName(), 51);
        NARROWING_LUT = Collections.unmodifiableMap(tmp3);
    }

    private static class ShortAnalyzer
    implements LiteralAnalyzer {
        private ShortAnalyzer() {
        }

        @Override
        public void validate(String s) {
            NumberRepresentation br = new NumberRepresentation(s, true, false, false){

                @Override
                void parse(String val2, int radix) {
                    Short.parseShort(val2, radix);
                }
            };
            br.validate();
        }

        @Override
        public Class<?> getLiteral() {
            return Integer.TYPE;
        }
    }

    private static class LongAnalyzer
    implements LiteralAnalyzer {
        private LongAnalyzer() {
        }

        @Override
        public void validate(String s) {
            NumberRepresentation br = new NumberRepresentation(s, true, true, false){

                @Override
                void parse(String val2, int radix) {
                    if (radix == 10) {
                        Long.parseLong(val2, radix);
                    } else if (new BigInteger(val2, radix).bitLength() > 64) {
                        throw new NumberFormatException("integer number too large");
                    }
                }
            };
            br.validate();
        }

        @Override
        public Class<?> getLiteral() {
            return Integer.TYPE;
        }
    }

    private static class IntAnalyzer
    implements LiteralAnalyzer {
        private IntAnalyzer() {
        }

        @Override
        public void validate(String s) {
            NumberRepresentation br = new NumberRepresentation(s, true, false, false){

                @Override
                void parse(String val2, int radix) {
                    if (radix == 10) {
                        Integer.parseInt(val2, radix);
                    } else if (new BigInteger(val2, radix).bitLength() > 32) {
                        throw new NumberFormatException("integer number too large");
                    }
                }
            };
            br.validate();
        }

        @Override
        public Class<?> getLiteral() {
            return Integer.TYPE;
        }
    }

    private static class FloatAnalyzer
    implements LiteralAnalyzer {
        private FloatAnalyzer() {
        }

        @Override
        public void validate(String s) {
            NumberRepresentation br = new NumberRepresentation(s, false, false, true){

                @Override
                void parse(String val2, int radix) {
                    Float f = Float.valueOf(Float.parseFloat(radix == 16 ? "0x" + val2 : val2));
                    if (this.doubleHasBecomeZero(f.floatValue())) {
                        throw new NumberFormatException("floating point number too small");
                    }
                    if (f.isInfinite()) {
                        throw new NumberFormatException("infinitive is not allowed");
                    }
                }
            };
            br.validate();
        }

        @Override
        public Class<?> getLiteral() {
            return Float.TYPE;
        }
    }

    private static class DoubleAnalyzer
    implements LiteralAnalyzer {
        private DoubleAnalyzer() {
        }

        @Override
        public void validate(String s) {
            NumberRepresentation br = new NumberRepresentation(s, false, false, false){

                @Override
                void parse(String val2, int radix) {
                    Double d = Double.parseDouble(radix == 16 ? "0x" + val2 : val2);
                    if (this.doubleHasBecomeZero(d)) {
                        throw new NumberFormatException("floating point number too small");
                    }
                    if (d.isInfinite()) {
                        throw new NumberFormatException("infinitive is not allowed");
                    }
                }
            };
            br.validate();
        }

        @Override
        public Class<?> getLiteral() {
            return Float.TYPE;
        }
    }

    private static class ByteAnalyzer
    implements LiteralAnalyzer {
        private ByteAnalyzer() {
        }

        @Override
        public void validate(String s) {
            NumberRepresentation br = new NumberRepresentation(s, true, false, false){

                @Override
                void parse(String val2, int radix) {
                    Byte.parseByte(val2, radix);
                }
            };
            br.validate();
        }

        @Override
        public Class<?> getLiteral() {
            return Integer.TYPE;
        }
    }

    private static class CharAnalyzer
    implements LiteralAnalyzer {
        private CharAnalyzer() {
        }

        @Override
        public void validate(String s) {
            if (s.length() != 3 || !s.startsWith("'") || !s.endsWith("'")) {
                throw new NumberFormatException("invalid character literal");
            }
        }

        @Override
        public Class<?> getLiteral() {
            return Character.TYPE;
        }
    }

    private static class BooleanAnalyzer
    implements LiteralAnalyzer {
        private BooleanAnalyzer() {
        }

        @Override
        public void validate(String s) {
            if (!"true".equals(s) && !"false".equals(s)) {
                throw new IllegalArgumentException("only 'true' or 'false' are supported");
            }
        }

        @Override
        public Class<?> getLiteral() {
            return Boolean.TYPE;
        }
    }

    private static abstract class NumberRepresentation {
        int radix;
        String val;
        boolean isIntegralType;
        boolean isLong;
        boolean isFloat;

        NumberRepresentation(String in, boolean isIntegralType, boolean isLong, boolean isFloat) {
            this.isLong = isLong;
            this.isFloat = isFloat;
            this.isIntegralType = isIntegralType;
            boolean isNegative = in.startsWith("-");
            boolean hasSign = PTRN_SIGN.matcher(in).find();
            String valWithoutSign = hasSign ? in.substring(1) : in;
            if (PTRN_HEX.matcher(valWithoutSign).matches()) {
                this.radix = 16;
                this.val = (isNegative ? "-" : "") + valWithoutSign.substring(2);
            } else if (PTRN_BIN.matcher(valWithoutSign).matches()) {
                this.radix = 2;
                this.val = (isNegative ? "-" : "") + valWithoutSign.substring(2);
            } else if (PTRN_OCT.matcher(valWithoutSign).matches()) {
                this.radix = 8;
                this.val = (isNegative ? "-" : "") + valWithoutSign.substring(1);
            } else {
                this.radix = 10;
                this.val = (isNegative ? "-" : "") + valWithoutSign;
            }
        }

        abstract void parse(String var1, int var2);

        void validate() {
            this.strip();
            this.parse(this.val, this.radix);
        }

        void strip() {
            if (this.isIntegralType) {
                this.removeAndValidateIntegerLiteralSuffix();
                this.removeAndValidateIntegerLiteralUnderscore();
            } else {
                this.removeAndValidateFloatingPointLiteralSuffix();
                this.removeAndValidateFloatingPointLiteralUnderscore();
            }
        }

        void removeAndValidateIntegerLiteralUnderscore() {
            if (PTRN_FAULTY_UNDERSCORE_INT.matcher(this.val).find()) {
                throw new NumberFormatException("improperly placed underscores");
            }
            this.val = this.val.replace("_", "");
        }

        void removeAndValidateFloatingPointLiteralUnderscore() {
            boolean isHex;
            boolean bl = isHex = this.radix == 16;
            if (PTRN_FAULTY_UNDERSCORE_FLOAT.matcher(this.val).find() || !isHex && PTRN_FAULTY_DEC_UNDERSCORE_FLOAT.matcher(this.val).find() || isHex && PTRN_FAULTY_HEX_UNDERSCORE_FLOAT.matcher(this.val).find()) {
                throw new NumberFormatException("improperly placed underscores");
            }
            this.val = this.val.replace("_", "");
        }

        void removeAndValidateIntegerLiteralSuffix() {
            boolean endsWithLSuffix = PTRN_LONG.matcher(this.val).find();
            if (endsWithLSuffix && !this.isLong) {
                throw new NumberFormatException("L/l not allowed for non-long types");
            }
            if (!endsWithLSuffix && this.isLong) {
                throw new NumberFormatException("L/l mandatory for long types");
            }
            if (endsWithLSuffix) {
                this.val = this.val.substring(0, this.val.length() - 1);
            }
        }

        void removeAndValidateFloatingPointLiteralSuffix() {
            boolean endsWithLSuffix = PTRN_LONG.matcher(this.val).find();
            boolean endsWithFSuffix = PTRN_FLOAT.matcher(this.val).find();
            boolean endsWithDSuffix = PTRN_DOUBLE.matcher(this.val).find();
            if (this.isFloat && endsWithDSuffix) {
                throw new NumberFormatException("Assiging double to a float");
            }
            if (endsWithLSuffix || endsWithFSuffix || endsWithDSuffix) {
                this.val = this.val.substring(0, this.val.length() - 1);
            }
        }

        boolean floatHasBecomeZero(float parsed) {
            if (parsed == 0.0f) {
                return this.floatHasBecomeZero();
            }
            return false;
        }

        boolean doubleHasBecomeZero(double parsed) {
            if (parsed == 0.0) {
                return this.floatHasBecomeZero();
            }
            return false;
        }

        private boolean floatHasBecomeZero() {
            if (this.radix == 10) {
                return PTRN_FLOAT_DEC_ZERO.matcher(this.val).matches();
            }
            return PTRN_FLOAT_HEX_ZERO.matcher(this.val).matches();
        }
    }

    private static interface LiteralAnalyzer {
        public void validate(String var1);

        public Class<?> getLiteral();
    }
}

