/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.util.Map;
import org.ldaptive.transport.netty.NettyConnectionFactoryTransport;

public class NioConnectionFactoryTransport
extends NettyConnectionFactoryTransport {
    public NioConnectionFactoryTransport() {
        this(0);
    }

    public NioConnectionFactoryTransport(int ioThreads) {
        this(NioConnectionFactoryTransport.class.getSimpleName(), ioThreads);
    }

    public NioConnectionFactoryTransport(String name, int ioThreads) {
        this(name, ioThreads, null);
    }

    public NioConnectionFactoryTransport(String name, int ioThreads, Map<ChannelOption, Object> options) {
        super(NioSocketChannel.class, new NioEventLoopGroup(ioThreads, new ThreadPerTaskExecutor(new DefaultThreadFactory(name, true, 5))), null, options);
    }

    public NioConnectionFactoryTransport(int ioThreads, int messageThreads) {
        this(NioConnectionFactoryTransport.class.getSimpleName(), ioThreads, messageThreads);
    }

    public NioConnectionFactoryTransport(String name, int ioThreads, int messageThreads) {
        this(name, ioThreads, messageThreads, null);
    }

    public NioConnectionFactoryTransport(String name, int ioThreads, int messageThreads, Map<ChannelOption, Object> options) {
        super(NioSocketChannel.class, new NioEventLoopGroup(ioThreads, new ThreadPerTaskExecutor(new DefaultThreadFactory(name.concat("-io"), true, 5))), new NioEventLoopGroup(messageThreads, new ThreadPerTaskExecutor(new DefaultThreadFactory(name.concat("-messages"), true, 5))), options);
    }
}

