/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyUtils {
    private static final long DEFAULT_SHUTDOWN_QUIET_PERIOD = 0L;
    private static final long DEFAULT_SHUTDOWN_MAX_TIMEOUT = 1000L;
    private static final boolean USE_NIO = Boolean.valueOf(System.getProperty("org.ldaptive.transport.netty.useNio", "false"));
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyUtils.class);

    private NettyUtils() {
    }

    public static Class<? extends Channel> getDefaultSocketChannelType() {
        if (Epoll.isAvailable() && !USE_NIO) {
            return EpollSocketChannel.class;
        }
        if (KQueue.isAvailable() && !USE_NIO) {
            return KQueueSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static EventLoopGroup createDefaultEventLoopGroup(String name, int numThreads) {
        if (Epoll.isAvailable() && !USE_NIO) {
            return new EpollEventLoopGroup(numThreads, new ThreadPerTaskExecutor(new DefaultThreadFactory(name, true, 5)));
        }
        if (KQueue.isAvailable() && !USE_NIO) {
            return new KQueueEventLoopGroup(numThreads, new ThreadPerTaskExecutor(new DefaultThreadFactory(name, true, 5)));
        }
        return new NioEventLoopGroup(numThreads, new ThreadPerTaskExecutor(new DefaultThreadFactory(name, true, 5)));
    }

    public static void shutdownGracefully(EventLoopGroup workerGroup) {
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        workerGroup.shutdownGracefully(0L, 1000L, TimeUnit.MILLISECONDS).addListener(f -> {
            shutdownLatch.countDown();
            if (!f.isSuccess()) {
                if (f.cause() != null) {
                    LOGGER.warn("Could not shutdown worker group {}", (Object)workerGroup, (Object)f.cause());
                } else {
                    LOGGER.warn("Could not shutdown worker group {}", (Object)workerGroup);
                }
            } else {
                LOGGER.trace("Worker group {} gracefully shutdown", (Object)workerGroup);
            }
        });
        try {
            if (!shutdownLatch.await(2000L, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Shutdown max timeout was not honored for worker group {}", (Object)workerGroup);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted during shutdown for worker group {}", (Object)workerGroup);
        }
    }

    static {
        LOGGER.debug("Detecting Epoll transport: {}", (Object)Epoll.isAvailable());
        LOGGER.debug("Detecting KQueue transport: {}", (Object)KQueue.isAvailable());
        LOGGER.debug("Overriding to use Nio transport: {}", (Object)USE_NIO);
    }
}

