/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport;

import java.lang.reflect.Constructor;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.netty.ConnectionTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportFactory {
    private static final String TRANSPORT_PROPERTY = "org.ldaptive.transport";
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportFactory.class);
    private static final Constructor<?> TRANSPORT_CONSTRUCTOR;

    private TransportFactory() {
    }

    public static Transport getTransport() {
        if (TRANSPORT_CONSTRUCTOR != null) {
            try {
                return (Transport)TRANSPORT_CONSTRUCTOR.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error creating new transport instance with {}", (Object)TRANSPORT_CONSTRUCTOR, (Object)e);
                throw new IllegalStateException(e);
            }
        }
        return new ConnectionTransport(1);
    }

    static {
        String transportClass = System.getProperty(TRANSPORT_PROPERTY);
        if (transportClass != null) {
            try {
                LOGGER.info("Setting ldap transport to {}", (Object)transportClass);
                TRANSPORT_CONSTRUCTOR = Class.forName(transportClass).getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error instantiating {}", (Object)transportClass, (Object)e);
                throw new IllegalStateException(e);
            }
        } else {
            TRANSPORT_CONSTRUCTOR = null;
        }
    }
}

