/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.sasl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.ldaptive.sasl.DefaultSaslClientRequest;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.QualityOfProtection;

public class DigestMD5BindRequest
extends DefaultSaslClientRequest {
    public static final Mechanism MECHANISM = Mechanism.DIGEST_MD5;
    private final QualityOfProtection[] allowedQoP;
    private final String authenticationID;
    private final String authorizationID;
    private final String realm;
    private final String password;

    public DigestMD5BindRequest(String authID, String authzID, String pass, String r, QualityOfProtection ... qop) {
        if (qop != null) {
            if (qop.length == 0) {
                throw new IllegalArgumentException("QOP cannot be empty");
            }
            Stream.of(qop).forEach(q -> {
                if (q == null) {
                    throw new IllegalArgumentException("QOP cannot be null");
                }
            });
        }
        this.authenticationID = authID;
        this.authorizationID = authzID;
        this.password = pass;
        this.realm = r;
        this.allowedQoP = qop;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.authenticationID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                if (this.realm == null) {
                    String defaultRealm = rc.getDefaultText();
                    if (defaultRealm == null) {
                        throw new IllegalStateException("Default realm required, but none provided");
                    }
                    rc.setText(defaultRealm);
                    continue;
                }
                rc.setText(this.realm);
                continue;
            }
            if (callback instanceof RealmChoiceCallback) {
                RealmChoiceCallback rcc = (RealmChoiceCallback)callback;
                if (this.realm == null) {
                    throw new IllegalStateException("Realm required, choose one of the following: " + Arrays.toString(rcc.getChoices()));
                }
                if (rcc.getChoices() == null) continue;
                int selectedIndex = IntStream.range(0, rcc.getChoices().length).filter(i -> rcc.getChoices()[i].equals(this.realm)).findFirst().getAsInt();
                rcc.setSelectedIndex(selectedIndex);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public Mechanism getMechanism() {
        return MECHANISM;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public Map<String, ?> getSaslProperties() {
        if (this.allowedQoP == null) {
            return null;
        }
        return Collections.singletonMap("javax.security.sasl.qop", Stream.of(this.allowedQoP).map(QualityOfProtection::string).collect(Collectors.joining(",")));
    }

    @Override
    public String toString() {
        return super.toString() + ", " + "allowedQoP=" + Arrays.toString((Object[])this.allowedQoP) + ", " + "authenticationID=" + this.authenticationID + ", " + "authorizationID=" + this.authorizationID + ", " + "realm=" + this.realm;
    }
}

