/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AddResponse;
import org.ldaptive.AttributeModification;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DeleteResponse;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.ModifyResponse;
import org.ldaptive.Result;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.ext.MergeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeOperation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConnectionFactory connectionFactory;

    public MergeOperation() {
    }

    public MergeOperation(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public Result execute(MergeRequest request) throws LdapException {
        try (Connection conn = this.connectionFactory.getConnection();){
            Result result;
            conn.open();
            LdapEntry sourceEntry = request.getEntry();
            SearchResponse searchResult = conn.operation(SearchRequest.objectScopeSearchRequest(sourceEntry.getDn(), request.getSearchAttributes())).execute();
            if (searchResult.getResultCode() != ResultCode.SUCCESS && searchResult.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
                throw new LdapException(searchResult.getResultCode(), String.format("Error searching for entry: %s, response did not return success or no_such_object: %s", sourceEntry, searchResult));
            }
            if (searchResult.entrySize() == 0) {
                if (request.getDeleteEntry()) {
                    this.logger.info("target entry does not exist, no delete performed for request {}", (Object)request);
                    result = null;
                } else {
                    result = this.add(request, sourceEntry);
                }
            } else {
                result = request.getDeleteEntry() ? this.delete(request, sourceEntry) : this.modify(request, sourceEntry, searchResult.getEntry());
            }
            Result result2 = result;
            return result2;
        }
    }

    protected Result modify(MergeRequest request, LdapEntry source, LdapEntry target) throws LdapException {
        AttributeModification[] modifications = LdapEntry.computeModifications(source, target);
        if (modifications != null && modifications.length > 0) {
            List<String> l;
            ArrayList<AttributeModification> resultModifications = new ArrayList<AttributeModification>(modifications.length);
            String[] includeAttrs = request.getIncludeAttributes();
            String[] excludeAttrs = request.getExcludeAttributes();
            if (includeAttrs != null && includeAttrs.length > 0) {
                l = Arrays.asList(includeAttrs);
                for (AttributeModification am : modifications) {
                    if (!l.contains(am.getAttribute().getName())) continue;
                    resultModifications.add(am);
                }
            } else if (excludeAttrs != null && excludeAttrs.length > 0) {
                l = Arrays.asList(excludeAttrs);
                for (AttributeModification am : modifications) {
                    if (l.contains(am.getAttribute().getName())) continue;
                    resultModifications.add(am);
                }
            } else {
                Collections.addAll(resultModifications, modifications);
            }
            if (!resultModifications.isEmpty()) {
                this.logger.info("modifying target entry {} with modifications {} from source entry {} for request {}", target, resultModifications, source, request);
                ModifyResponse result = ModifyOperation.execute(this.connectionFactory, (ModifyRequest)ModifyRequest.builder().dn(target.getDn()).modificiations((AttributeModification[])resultModifications.toArray(AttributeModification[]::new)).build());
                this.logger.info("modified target entry {} with modifications {} from source entry {} for request {}", target, resultModifications, source, request);
                return result;
            }
        }
        this.logger.info("target entry {} equals source entry {}, no modification performed for request {}", target, source, request);
        return null;
    }

    protected Result add(MergeRequest request, LdapEntry entry) throws LdapException {
        AddResponse result = AddOperation.execute(this.connectionFactory, (AddRequest)AddRequest.builder().dn(entry.getDn()).attributes(entry.getAttributes()).build());
        this.logger.info("added entry {} for request {}", (Object)entry, (Object)request);
        return result;
    }

    protected Result delete(MergeRequest request, LdapEntry entry) throws LdapException {
        DeleteResponse result = DeleteOperation.execute(this.connectionFactory, new DeleteRequest(entry.getDn()));
        this.logger.info("delete entry {} for request {}", (Object)entry, (Object)request);
        return result;
    }
}

